/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Address;
import com.squareup.square.types.CustomerTaxIds;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateCustomerRequest {
    private final String customerId;
    private final Optional<String> givenName;
    private final Optional<String> familyName;
    private final Optional<String> companyName;
    private final Optional<String> nickname;
    private final Optional<String> emailAddress;
    private final Optional<Address> address;
    private final Optional<String> phoneNumber;
    private final Optional<String> referenceId;
    private final Optional<String> note;
    private final Optional<String> birthday;
    private final Optional<Long> version;
    private final Optional<CustomerTaxIds> taxIds;
    private final Map<String, Object> additionalProperties;

    private UpdateCustomerRequest(String customerId, Optional<String> givenName, Optional<String> familyName, Optional<String> companyName, Optional<String> nickname, Optional<String> emailAddress, Optional<Address> address, Optional<String> phoneNumber, Optional<String> referenceId, Optional<String> note, Optional<String> birthday, Optional<Long> version, Optional<CustomerTaxIds> taxIds, Map<String, Object> additionalProperties) {
        this.customerId = customerId;
        this.givenName = givenName;
        this.familyName = familyName;
        this.companyName = companyName;
        this.nickname = nickname;
        this.emailAddress = emailAddress;
        this.address = address;
        this.phoneNumber = phoneNumber;
        this.referenceId = referenceId;
        this.note = note;
        this.birthday = birthday;
        this.version = version;
        this.taxIds = taxIds;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="customer_id")
    public String getCustomerId() {
        return this.customerId;
    }

    @JsonIgnore
    public Optional<String> getGivenName() {
        if (this.givenName == null) {
            return Optional.empty();
        }
        return this.givenName;
    }

    @JsonIgnore
    public Optional<String> getFamilyName() {
        if (this.familyName == null) {
            return Optional.empty();
        }
        return this.familyName;
    }

    @JsonIgnore
    public Optional<String> getCompanyName() {
        if (this.companyName == null) {
            return Optional.empty();
        }
        return this.companyName;
    }

    @JsonIgnore
    public Optional<String> getNickname() {
        if (this.nickname == null) {
            return Optional.empty();
        }
        return this.nickname;
    }

    @JsonIgnore
    public Optional<String> getEmailAddress() {
        if (this.emailAddress == null) {
            return Optional.empty();
        }
        return this.emailAddress;
    }

    @JsonProperty(value="address")
    public Optional<Address> getAddress() {
        return this.address;
    }

    @JsonIgnore
    public Optional<String> getPhoneNumber() {
        if (this.phoneNumber == null) {
            return Optional.empty();
        }
        return this.phoneNumber;
    }

    @JsonIgnore
    public Optional<String> getReferenceId() {
        if (this.referenceId == null) {
            return Optional.empty();
        }
        return this.referenceId;
    }

    @JsonIgnore
    public Optional<String> getNote() {
        if (this.note == null) {
            return Optional.empty();
        }
        return this.note;
    }

    @JsonIgnore
    public Optional<String> getBirthday() {
        if (this.birthday == null) {
            return Optional.empty();
        }
        return this.birthday;
    }

    @JsonProperty(value="version")
    public Optional<Long> getVersion() {
        return this.version;
    }

    @JsonProperty(value="tax_ids")
    public Optional<CustomerTaxIds> getTaxIds() {
        return this.taxIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="given_name")
    private Optional<String> _getGivenName() {
        return this.givenName;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="family_name")
    private Optional<String> _getFamilyName() {
        return this.familyName;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="company_name")
    private Optional<String> _getCompanyName() {
        return this.companyName;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="nickname")
    private Optional<String> _getNickname() {
        return this.nickname;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="email_address")
    private Optional<String> _getEmailAddress() {
        return this.emailAddress;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="phone_number")
    private Optional<String> _getPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="reference_id")
    private Optional<String> _getReferenceId() {
        return this.referenceId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="note")
    private Optional<String> _getNote() {
        return this.note;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="birthday")
    private Optional<String> _getBirthday() {
        return this.birthday;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateCustomerRequest && this.equalTo((UpdateCustomerRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateCustomerRequest other) {
        return this.customerId.equals(other.customerId) && this.givenName.equals(other.givenName) && this.familyName.equals(other.familyName) && this.companyName.equals(other.companyName) && this.nickname.equals(other.nickname) && this.emailAddress.equals(other.emailAddress) && this.address.equals(other.address) && this.phoneNumber.equals(other.phoneNumber) && this.referenceId.equals(other.referenceId) && this.note.equals(other.note) && this.birthday.equals(other.birthday) && this.version.equals(other.version) && this.taxIds.equals(other.taxIds);
    }

    public int hashCode() {
        return Objects.hash(this.customerId, this.givenName, this.familyName, this.companyName, this.nickname, this.emailAddress, this.address, this.phoneNumber, this.referenceId, this.note, this.birthday, this.version, this.taxIds);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CustomerIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CustomerIdStage,
    _FinalStage {
        private String customerId;
        private Optional<CustomerTaxIds> taxIds = Optional.empty();
        private Optional<Long> version = Optional.empty();
        private Optional<String> birthday = Optional.empty();
        private Optional<String> note = Optional.empty();
        private Optional<String> referenceId = Optional.empty();
        private Optional<String> phoneNumber = Optional.empty();
        private Optional<Address> address = Optional.empty();
        private Optional<String> emailAddress = Optional.empty();
        private Optional<String> nickname = Optional.empty();
        private Optional<String> companyName = Optional.empty();
        private Optional<String> familyName = Optional.empty();
        private Optional<String> givenName = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdateCustomerRequest other) {
            this.customerId(other.getCustomerId());
            this.givenName(other.getGivenName());
            this.familyName(other.getFamilyName());
            this.companyName(other.getCompanyName());
            this.nickname(other.getNickname());
            this.emailAddress(other.getEmailAddress());
            this.address(other.getAddress());
            this.phoneNumber(other.getPhoneNumber());
            this.referenceId(other.getReferenceId());
            this.note(other.getNote());
            this.birthday(other.getBirthday());
            this.version(other.getVersion());
            this.taxIds(other.getTaxIds());
            return this;
        }

        @Override
        @JsonSetter(value="customer_id")
        public _FinalStage customerId(@NotNull String customerId) {
            this.customerId = Objects.requireNonNull(customerId, "customerId must not be null");
            return this;
        }

        @Override
        public _FinalStage taxIds(CustomerTaxIds taxIds) {
            this.taxIds = Optional.ofNullable(taxIds);
            return this;
        }

        @Override
        @JsonSetter(value="tax_ids", nulls=Nulls.SKIP)
        public _FinalStage taxIds(Optional<CustomerTaxIds> taxIds) {
            this.taxIds = taxIds;
            return this;
        }

        @Override
        public _FinalStage version(Long version) {
            this.version = Optional.ofNullable(version);
            return this;
        }

        @Override
        @JsonSetter(value="version", nulls=Nulls.SKIP)
        public _FinalStage version(Optional<Long> version) {
            this.version = version;
            return this;
        }

        @Override
        public _FinalStage birthday(Nullable<String> birthday) {
            this.birthday = birthday.isNull() ? null : (birthday.isEmpty() ? Optional.empty() : Optional.of(birthday.get()));
            return this;
        }

        @Override
        public _FinalStage birthday(String birthday) {
            this.birthday = Optional.ofNullable(birthday);
            return this;
        }

        @Override
        @JsonSetter(value="birthday", nulls=Nulls.SKIP)
        public _FinalStage birthday(Optional<String> birthday) {
            this.birthday = birthday;
            return this;
        }

        @Override
        public _FinalStage note(Nullable<String> note) {
            this.note = note.isNull() ? null : (note.isEmpty() ? Optional.empty() : Optional.of(note.get()));
            return this;
        }

        @Override
        public _FinalStage note(String note) {
            this.note = Optional.ofNullable(note);
            return this;
        }

        @Override
        @JsonSetter(value="note", nulls=Nulls.SKIP)
        public _FinalStage note(Optional<String> note) {
            this.note = note;
            return this;
        }

        @Override
        public _FinalStage referenceId(Nullable<String> referenceId) {
            this.referenceId = referenceId.isNull() ? null : (referenceId.isEmpty() ? Optional.empty() : Optional.of(referenceId.get()));
            return this;
        }

        @Override
        public _FinalStage referenceId(String referenceId) {
            this.referenceId = Optional.ofNullable(referenceId);
            return this;
        }

        @Override
        @JsonSetter(value="reference_id", nulls=Nulls.SKIP)
        public _FinalStage referenceId(Optional<String> referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        @Override
        public _FinalStage phoneNumber(Nullable<String> phoneNumber) {
            this.phoneNumber = phoneNumber.isNull() ? null : (phoneNumber.isEmpty() ? Optional.empty() : Optional.of(phoneNumber.get()));
            return this;
        }

        @Override
        public _FinalStage phoneNumber(String phoneNumber) {
            this.phoneNumber = Optional.ofNullable(phoneNumber);
            return this;
        }

        @Override
        @JsonSetter(value="phone_number", nulls=Nulls.SKIP)
        public _FinalStage phoneNumber(Optional<String> phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        @Override
        public _FinalStage address(Address address) {
            this.address = Optional.ofNullable(address);
            return this;
        }

        @Override
        @JsonSetter(value="address", nulls=Nulls.SKIP)
        public _FinalStage address(Optional<Address> address) {
            this.address = address;
            return this;
        }

        @Override
        public _FinalStage emailAddress(Nullable<String> emailAddress) {
            this.emailAddress = emailAddress.isNull() ? null : (emailAddress.isEmpty() ? Optional.empty() : Optional.of(emailAddress.get()));
            return this;
        }

        @Override
        public _FinalStage emailAddress(String emailAddress) {
            this.emailAddress = Optional.ofNullable(emailAddress);
            return this;
        }

        @Override
        @JsonSetter(value="email_address", nulls=Nulls.SKIP)
        public _FinalStage emailAddress(Optional<String> emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        @Override
        public _FinalStage nickname(Nullable<String> nickname) {
            this.nickname = nickname.isNull() ? null : (nickname.isEmpty() ? Optional.empty() : Optional.of(nickname.get()));
            return this;
        }

        @Override
        public _FinalStage nickname(String nickname) {
            this.nickname = Optional.ofNullable(nickname);
            return this;
        }

        @Override
        @JsonSetter(value="nickname", nulls=Nulls.SKIP)
        public _FinalStage nickname(Optional<String> nickname) {
            this.nickname = nickname;
            return this;
        }

        @Override
        public _FinalStage companyName(Nullable<String> companyName) {
            this.companyName = companyName.isNull() ? null : (companyName.isEmpty() ? Optional.empty() : Optional.of(companyName.get()));
            return this;
        }

        @Override
        public _FinalStage companyName(String companyName) {
            this.companyName = Optional.ofNullable(companyName);
            return this;
        }

        @Override
        @JsonSetter(value="company_name", nulls=Nulls.SKIP)
        public _FinalStage companyName(Optional<String> companyName) {
            this.companyName = companyName;
            return this;
        }

        @Override
        public _FinalStage familyName(Nullable<String> familyName) {
            this.familyName = familyName.isNull() ? null : (familyName.isEmpty() ? Optional.empty() : Optional.of(familyName.get()));
            return this;
        }

        @Override
        public _FinalStage familyName(String familyName) {
            this.familyName = Optional.ofNullable(familyName);
            return this;
        }

        @Override
        @JsonSetter(value="family_name", nulls=Nulls.SKIP)
        public _FinalStage familyName(Optional<String> familyName) {
            this.familyName = familyName;
            return this;
        }

        @Override
        public _FinalStage givenName(Nullable<String> givenName) {
            this.givenName = givenName.isNull() ? null : (givenName.isEmpty() ? Optional.empty() : Optional.of(givenName.get()));
            return this;
        }

        @Override
        public _FinalStage givenName(String givenName) {
            this.givenName = Optional.ofNullable(givenName);
            return this;
        }

        @Override
        @JsonSetter(value="given_name", nulls=Nulls.SKIP)
        public _FinalStage givenName(Optional<String> givenName) {
            this.givenName = givenName;
            return this;
        }

        @Override
        public UpdateCustomerRequest build() {
            return new UpdateCustomerRequest(this.customerId, this.givenName, this.familyName, this.companyName, this.nickname, this.emailAddress, this.address, this.phoneNumber, this.referenceId, this.note, this.birthday, this.version, this.taxIds, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdateCustomerRequest build();

        public _FinalStage givenName(Optional<String> var1);

        public _FinalStage givenName(String var1);

        public _FinalStage givenName(Nullable<String> var1);

        public _FinalStage familyName(Optional<String> var1);

        public _FinalStage familyName(String var1);

        public _FinalStage familyName(Nullable<String> var1);

        public _FinalStage companyName(Optional<String> var1);

        public _FinalStage companyName(String var1);

        public _FinalStage companyName(Nullable<String> var1);

        public _FinalStage nickname(Optional<String> var1);

        public _FinalStage nickname(String var1);

        public _FinalStage nickname(Nullable<String> var1);

        public _FinalStage emailAddress(Optional<String> var1);

        public _FinalStage emailAddress(String var1);

        public _FinalStage emailAddress(Nullable<String> var1);

        public _FinalStage address(Optional<Address> var1);

        public _FinalStage address(Address var1);

        public _FinalStage phoneNumber(Optional<String> var1);

        public _FinalStage phoneNumber(String var1);

        public _FinalStage phoneNumber(Nullable<String> var1);

        public _FinalStage referenceId(Optional<String> var1);

        public _FinalStage referenceId(String var1);

        public _FinalStage referenceId(Nullable<String> var1);

        public _FinalStage note(Optional<String> var1);

        public _FinalStage note(String var1);

        public _FinalStage note(Nullable<String> var1);

        public _FinalStage birthday(Optional<String> var1);

        public _FinalStage birthday(String var1);

        public _FinalStage birthday(Nullable<String> var1);

        public _FinalStage version(Optional<Long> var1);

        public _FinalStage version(Long var1);

        public _FinalStage taxIds(Optional<CustomerTaxIds> var1);

        public _FinalStage taxIds(CustomerTaxIds var1);
    }

    public static interface CustomerIdStage {
        public _FinalStage customerId(@NotNull String var1);

        public Builder from(UpdateCustomerRequest var1);
    }
}

