/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Booking;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateBookingRequest {
    private final String bookingId;
    private final Optional<String> idempotencyKey;
    private final Booking booking;
    private final Map<String, Object> additionalProperties;

    private UpdateBookingRequest(String bookingId, Optional<String> idempotencyKey, Booking booking, Map<String, Object> additionalProperties) {
        this.bookingId = bookingId;
        this.idempotencyKey = idempotencyKey;
        this.booking = booking;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="booking_id")
    public String getBookingId() {
        return this.bookingId;
    }

    @JsonIgnore
    public Optional<String> getIdempotencyKey() {
        if (this.idempotencyKey == null) {
            return Optional.empty();
        }
        return this.idempotencyKey;
    }

    @JsonProperty(value="booking")
    public Booking getBooking() {
        return this.booking;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="idempotency_key")
    private Optional<String> _getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateBookingRequest && this.equalTo((UpdateBookingRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateBookingRequest other) {
        return this.bookingId.equals(other.bookingId) && this.idempotencyKey.equals(other.idempotencyKey) && this.booking.equals(other.booking);
    }

    public int hashCode() {
        return Objects.hash(this.bookingId, this.idempotencyKey, this.booking);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static BookingIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements BookingIdStage,
    BookingStage,
    _FinalStage {
        private String bookingId;
        private Booking booking;
        private Optional<String> idempotencyKey = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdateBookingRequest other) {
            this.bookingId(other.getBookingId());
            this.idempotencyKey(other.getIdempotencyKey());
            this.booking(other.getBooking());
            return this;
        }

        @Override
        @JsonSetter(value="booking_id")
        public BookingStage bookingId(@NotNull String bookingId) {
            this.bookingId = Objects.requireNonNull(bookingId, "bookingId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="booking")
        public _FinalStage booking(@NotNull Booking booking) {
            this.booking = Objects.requireNonNull(booking, "booking must not be null");
            return this;
        }

        @Override
        public _FinalStage idempotencyKey(Nullable<String> idempotencyKey) {
            this.idempotencyKey = idempotencyKey.isNull() ? null : (idempotencyKey.isEmpty() ? Optional.empty() : Optional.of(idempotencyKey.get()));
            return this;
        }

        @Override
        public _FinalStage idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = Optional.ofNullable(idempotencyKey);
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key", nulls=Nulls.SKIP)
        public _FinalStage idempotencyKey(Optional<String> idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        @Override
        public UpdateBookingRequest build() {
            return new UpdateBookingRequest(this.bookingId, this.idempotencyKey, this.booking, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdateBookingRequest build();

        public _FinalStage idempotencyKey(Optional<String> var1);

        public _FinalStage idempotencyKey(String var1);

        public _FinalStage idempotencyKey(Nullable<String> var1);
    }

    public static interface BookingStage {
        public _FinalStage booking(@NotNull Booking var1);
    }

    public static interface BookingIdStage {
        public BookingStage bookingId(@NotNull String var1);

        public Builder from(UpdateBookingRequest var1);
    }
}

