/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class TransactionType {
    public static final TransactionType CREDIT = new TransactionType(Value.CREDIT, "CREDIT");
    public static final TransactionType DEBIT = new TransactionType(Value.DEBIT, "DEBIT");
    private final Value value;
    private final String string;

    TransactionType(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof TransactionType && this.string.equals(((TransactionType)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case CREDIT: {
                return visitor.visitCredit();
            }
            case DEBIT: {
                return visitor.visitDebit();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static TransactionType valueOf(String value) {
        switch (value) {
            case "CREDIT": {
                return CREDIT;
            }
            case "DEBIT": {
                return DEBIT;
            }
        }
        return new TransactionType(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitDebit();

        public T visitCredit();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        DEBIT,
        CREDIT,
        UNKNOWN;

    }
}

