/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Address;
import com.squareup.square.types.Refund;
import com.squareup.square.types.Tender;
import com.squareup.square.types.TransactionProduct;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Transaction {
    private final Optional<String> id;
    private final Optional<String> locationId;
    private final Optional<String> createdAt;
    private final Optional<List<Tender>> tenders;
    private final Optional<List<Refund>> refunds;
    private final Optional<String> referenceId;
    private final Optional<TransactionProduct> product;
    private final Optional<String> clientId;
    private final Optional<Address> shippingAddress;
    private final Optional<String> orderId;
    private final Map<String, Object> additionalProperties;

    private Transaction(Optional<String> id, Optional<String> locationId, Optional<String> createdAt, Optional<List<Tender>> tenders, Optional<List<Refund>> refunds, Optional<String> referenceId, Optional<TransactionProduct> product, Optional<String> clientId, Optional<Address> shippingAddress, Optional<String> orderId, Map<String, Object> additionalProperties) {
        this.id = id;
        this.locationId = locationId;
        this.createdAt = createdAt;
        this.tenders = tenders;
        this.refunds = refunds;
        this.referenceId = referenceId;
        this.product = product;
        this.clientId = clientId;
        this.shippingAddress = shippingAddress;
        this.orderId = orderId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> getLocationId() {
        if (this.locationId == null) {
            return Optional.empty();
        }
        return this.locationId;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonIgnore
    public Optional<List<Tender>> getTenders() {
        if (this.tenders == null) {
            return Optional.empty();
        }
        return this.tenders;
    }

    @JsonIgnore
    public Optional<List<Refund>> getRefunds() {
        if (this.refunds == null) {
            return Optional.empty();
        }
        return this.refunds;
    }

    @JsonIgnore
    public Optional<String> getReferenceId() {
        if (this.referenceId == null) {
            return Optional.empty();
        }
        return this.referenceId;
    }

    @JsonProperty(value="product")
    public Optional<TransactionProduct> getProduct() {
        return this.product;
    }

    @JsonIgnore
    public Optional<String> getClientId() {
        if (this.clientId == null) {
            return Optional.empty();
        }
        return this.clientId;
    }

    @JsonProperty(value="shipping_address")
    public Optional<Address> getShippingAddress() {
        return this.shippingAddress;
    }

    @JsonIgnore
    public Optional<String> getOrderId() {
        if (this.orderId == null) {
            return Optional.empty();
        }
        return this.orderId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location_id")
    private Optional<String> _getLocationId() {
        return this.locationId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="tenders")
    private Optional<List<Tender>> _getTenders() {
        return this.tenders;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="refunds")
    private Optional<List<Refund>> _getRefunds() {
        return this.refunds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="reference_id")
    private Optional<String> _getReferenceId() {
        return this.referenceId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="client_id")
    private Optional<String> _getClientId() {
        return this.clientId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="order_id")
    private Optional<String> _getOrderId() {
        return this.orderId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Transaction && this.equalTo((Transaction)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Transaction other) {
        return this.id.equals(other.id) && this.locationId.equals(other.locationId) && this.createdAt.equals(other.createdAt) && this.tenders.equals(other.tenders) && this.refunds.equals(other.refunds) && this.referenceId.equals(other.referenceId) && this.product.equals(other.product) && this.clientId.equals(other.clientId) && this.shippingAddress.equals(other.shippingAddress) && this.orderId.equals(other.orderId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.locationId, this.createdAt, this.tenders, this.refunds, this.referenceId, this.product, this.clientId, this.shippingAddress, this.orderId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> locationId = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<List<Tender>> tenders = Optional.empty();
        private Optional<List<Refund>> refunds = Optional.empty();
        private Optional<String> referenceId = Optional.empty();
        private Optional<TransactionProduct> product = Optional.empty();
        private Optional<String> clientId = Optional.empty();
        private Optional<Address> shippingAddress = Optional.empty();
        private Optional<String> orderId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Transaction other) {
            this.id(other.getId());
            this.locationId(other.getLocationId());
            this.createdAt(other.getCreatedAt());
            this.tenders(other.getTenders());
            this.refunds(other.getRefunds());
            this.referenceId(other.getReferenceId());
            this.product(other.getProduct());
            this.clientId(other.getClientId());
            this.shippingAddress(other.getShippingAddress());
            this.orderId(other.getOrderId());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="location_id", nulls=Nulls.SKIP)
        public Builder locationId(Optional<String> locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = Optional.ofNullable(locationId);
            return this;
        }

        public Builder locationId(Nullable<String> locationId) {
            this.locationId = locationId.isNull() ? null : (locationId.isEmpty() ? Optional.empty() : Optional.of(locationId.get()));
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="tenders", nulls=Nulls.SKIP)
        public Builder tenders(Optional<List<Tender>> tenders) {
            this.tenders = tenders;
            return this;
        }

        public Builder tenders(List<Tender> tenders) {
            this.tenders = Optional.ofNullable(tenders);
            return this;
        }

        public Builder tenders(Nullable<List<Tender>> tenders) {
            this.tenders = tenders.isNull() ? null : (tenders.isEmpty() ? Optional.empty() : Optional.of(tenders.get()));
            return this;
        }

        @JsonSetter(value="refunds", nulls=Nulls.SKIP)
        public Builder refunds(Optional<List<Refund>> refunds) {
            this.refunds = refunds;
            return this;
        }

        public Builder refunds(List<Refund> refunds) {
            this.refunds = Optional.ofNullable(refunds);
            return this;
        }

        public Builder refunds(Nullable<List<Refund>> refunds) {
            this.refunds = refunds.isNull() ? null : (refunds.isEmpty() ? Optional.empty() : Optional.of(refunds.get()));
            return this;
        }

        @JsonSetter(value="reference_id", nulls=Nulls.SKIP)
        public Builder referenceId(Optional<String> referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public Builder referenceId(String referenceId) {
            this.referenceId = Optional.ofNullable(referenceId);
            return this;
        }

        public Builder referenceId(Nullable<String> referenceId) {
            this.referenceId = referenceId.isNull() ? null : (referenceId.isEmpty() ? Optional.empty() : Optional.of(referenceId.get()));
            return this;
        }

        @JsonSetter(value="product", nulls=Nulls.SKIP)
        public Builder product(Optional<TransactionProduct> product) {
            this.product = product;
            return this;
        }

        public Builder product(TransactionProduct product) {
            this.product = Optional.ofNullable(product);
            return this;
        }

        @JsonSetter(value="client_id", nulls=Nulls.SKIP)
        public Builder clientId(Optional<String> clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = Optional.ofNullable(clientId);
            return this;
        }

        public Builder clientId(Nullable<String> clientId) {
            this.clientId = clientId.isNull() ? null : (clientId.isEmpty() ? Optional.empty() : Optional.of(clientId.get()));
            return this;
        }

        @JsonSetter(value="shipping_address", nulls=Nulls.SKIP)
        public Builder shippingAddress(Optional<Address> shippingAddress) {
            this.shippingAddress = shippingAddress;
            return this;
        }

        public Builder shippingAddress(Address shippingAddress) {
            this.shippingAddress = Optional.ofNullable(shippingAddress);
            return this;
        }

        @JsonSetter(value="order_id", nulls=Nulls.SKIP)
        public Builder orderId(Optional<String> orderId) {
            this.orderId = orderId;
            return this;
        }

        public Builder orderId(String orderId) {
            this.orderId = Optional.ofNullable(orderId);
            return this;
        }

        public Builder orderId(Nullable<String> orderId) {
            this.orderId = orderId.isNull() ? null : (orderId.isEmpty() ? Optional.empty() : Optional.of(orderId.get()));
            return this;
        }

        public Transaction build() {
            return new Transaction(this.id, this.locationId, this.createdAt, this.tenders, this.refunds, this.referenceId, this.product, this.clientId, this.shippingAddress, this.orderId, this.additionalProperties);
        }
    }
}

