/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TipSettings {
    private final Optional<Boolean> allowTipping;
    private final Optional<Boolean> separateTipScreen;
    private final Optional<Boolean> customTipField;
    private final Optional<List<Integer>> tipPercentages;
    private final Optional<Boolean> smartTipping;
    private final Map<String, Object> additionalProperties;

    private TipSettings(Optional<Boolean> allowTipping, Optional<Boolean> separateTipScreen, Optional<Boolean> customTipField, Optional<List<Integer>> tipPercentages, Optional<Boolean> smartTipping, Map<String, Object> additionalProperties) {
        this.allowTipping = allowTipping;
        this.separateTipScreen = separateTipScreen;
        this.customTipField = customTipField;
        this.tipPercentages = tipPercentages;
        this.smartTipping = smartTipping;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<Boolean> getAllowTipping() {
        if (this.allowTipping == null) {
            return Optional.empty();
        }
        return this.allowTipping;
    }

    @JsonIgnore
    public Optional<Boolean> getSeparateTipScreen() {
        if (this.separateTipScreen == null) {
            return Optional.empty();
        }
        return this.separateTipScreen;
    }

    @JsonIgnore
    public Optional<Boolean> getCustomTipField() {
        if (this.customTipField == null) {
            return Optional.empty();
        }
        return this.customTipField;
    }

    @JsonIgnore
    public Optional<List<Integer>> getTipPercentages() {
        if (this.tipPercentages == null) {
            return Optional.empty();
        }
        return this.tipPercentages;
    }

    @JsonIgnore
    public Optional<Boolean> getSmartTipping() {
        if (this.smartTipping == null) {
            return Optional.empty();
        }
        return this.smartTipping;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="allow_tipping")
    private Optional<Boolean> _getAllowTipping() {
        return this.allowTipping;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="separate_tip_screen")
    private Optional<Boolean> _getSeparateTipScreen() {
        return this.separateTipScreen;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="custom_tip_field")
    private Optional<Boolean> _getCustomTipField() {
        return this.customTipField;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="tip_percentages")
    private Optional<List<Integer>> _getTipPercentages() {
        return this.tipPercentages;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="smart_tipping")
    private Optional<Boolean> _getSmartTipping() {
        return this.smartTipping;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TipSettings && this.equalTo((TipSettings)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TipSettings other) {
        return this.allowTipping.equals(other.allowTipping) && this.separateTipScreen.equals(other.separateTipScreen) && this.customTipField.equals(other.customTipField) && this.tipPercentages.equals(other.tipPercentages) && this.smartTipping.equals(other.smartTipping);
    }

    public int hashCode() {
        return Objects.hash(this.allowTipping, this.separateTipScreen, this.customTipField, this.tipPercentages, this.smartTipping);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Boolean> allowTipping = Optional.empty();
        private Optional<Boolean> separateTipScreen = Optional.empty();
        private Optional<Boolean> customTipField = Optional.empty();
        private Optional<List<Integer>> tipPercentages = Optional.empty();
        private Optional<Boolean> smartTipping = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(TipSettings other) {
            this.allowTipping(other.getAllowTipping());
            this.separateTipScreen(other.getSeparateTipScreen());
            this.customTipField(other.getCustomTipField());
            this.tipPercentages(other.getTipPercentages());
            this.smartTipping(other.getSmartTipping());
            return this;
        }

        @JsonSetter(value="allow_tipping", nulls=Nulls.SKIP)
        public Builder allowTipping(Optional<Boolean> allowTipping) {
            this.allowTipping = allowTipping;
            return this;
        }

        public Builder allowTipping(Boolean allowTipping) {
            this.allowTipping = Optional.ofNullable(allowTipping);
            return this;
        }

        public Builder allowTipping(Nullable<Boolean> allowTipping) {
            this.allowTipping = allowTipping.isNull() ? null : (allowTipping.isEmpty() ? Optional.empty() : Optional.of(allowTipping.get()));
            return this;
        }

        @JsonSetter(value="separate_tip_screen", nulls=Nulls.SKIP)
        public Builder separateTipScreen(Optional<Boolean> separateTipScreen) {
            this.separateTipScreen = separateTipScreen;
            return this;
        }

        public Builder separateTipScreen(Boolean separateTipScreen) {
            this.separateTipScreen = Optional.ofNullable(separateTipScreen);
            return this;
        }

        public Builder separateTipScreen(Nullable<Boolean> separateTipScreen) {
            this.separateTipScreen = separateTipScreen.isNull() ? null : (separateTipScreen.isEmpty() ? Optional.empty() : Optional.of(separateTipScreen.get()));
            return this;
        }

        @JsonSetter(value="custom_tip_field", nulls=Nulls.SKIP)
        public Builder customTipField(Optional<Boolean> customTipField) {
            this.customTipField = customTipField;
            return this;
        }

        public Builder customTipField(Boolean customTipField) {
            this.customTipField = Optional.ofNullable(customTipField);
            return this;
        }

        public Builder customTipField(Nullable<Boolean> customTipField) {
            this.customTipField = customTipField.isNull() ? null : (customTipField.isEmpty() ? Optional.empty() : Optional.of(customTipField.get()));
            return this;
        }

        @JsonSetter(value="tip_percentages", nulls=Nulls.SKIP)
        public Builder tipPercentages(Optional<List<Integer>> tipPercentages) {
            this.tipPercentages = tipPercentages;
            return this;
        }

        public Builder tipPercentages(List<Integer> tipPercentages) {
            this.tipPercentages = Optional.ofNullable(tipPercentages);
            return this;
        }

        public Builder tipPercentages(Nullable<List<Integer>> tipPercentages) {
            this.tipPercentages = tipPercentages.isNull() ? null : (tipPercentages.isEmpty() ? Optional.empty() : Optional.of(tipPercentages.get()));
            return this;
        }

        @JsonSetter(value="smart_tipping", nulls=Nulls.SKIP)
        public Builder smartTipping(Optional<Boolean> smartTipping) {
            this.smartTipping = smartTipping;
            return this;
        }

        public Builder smartTipping(Boolean smartTipping) {
            this.smartTipping = Optional.ofNullable(smartTipping);
            return this;
        }

        public Builder smartTipping(Nullable<Boolean> smartTipping) {
            this.smartTipping = smartTipping.isNull() ? null : (smartTipping.isEmpty() ? Optional.empty() : Optional.of(smartTipping.get()));
            return this;
        }

        public TipSettings build() {
            return new TipSettings(this.allowTipping, this.separateTipScreen, this.customTipField, this.tipPercentages, this.smartTipping, this.additionalProperties);
        }
    }
}

