/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.TimecardFilter;
import com.squareup.square.types.TimecardSort;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TimecardQuery {
    private final Optional<TimecardFilter> filter;
    private final Optional<TimecardSort> sort;
    private final Map<String, Object> additionalProperties;

    private TimecardQuery(Optional<TimecardFilter> filter, Optional<TimecardSort> sort, Map<String, Object> additionalProperties) {
        this.filter = filter;
        this.sort = sort;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="filter")
    public Optional<TimecardFilter> getFilter() {
        return this.filter;
    }

    @JsonProperty(value="sort")
    public Optional<TimecardSort> getSort() {
        return this.sort;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TimecardQuery && this.equalTo((TimecardQuery)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TimecardQuery other) {
        return this.filter.equals(other.filter) && this.sort.equals(other.sort);
    }

    public int hashCode() {
        return Objects.hash(this.filter, this.sort);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<TimecardFilter> filter = Optional.empty();
        private Optional<TimecardSort> sort = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(TimecardQuery other) {
            this.filter(other.getFilter());
            this.sort(other.getSort());
            return this;
        }

        @JsonSetter(value="filter", nulls=Nulls.SKIP)
        public Builder filter(Optional<TimecardFilter> filter) {
            this.filter = filter;
            return this;
        }

        public Builder filter(TimecardFilter filter) {
            this.filter = Optional.ofNullable(filter);
            return this;
        }

        @JsonSetter(value="sort", nulls=Nulls.SKIP)
        public Builder sort(Optional<TimecardSort> sort) {
            this.sort = sort;
            return this;
        }

        public Builder sort(TimecardSort sort) {
            this.sort = Optional.ofNullable(sort);
            return this;
        }

        public TimecardQuery build() {
            return new TimecardQuery(this.filter, this.sort, this.additionalProperties);
        }
    }
}

