/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.TerminalRefundQueryFilter;
import com.squareup.square.types.TerminalRefundQuerySort;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TerminalRefundQuery {
    private final Optional<TerminalRefundQueryFilter> filter;
    private final Optional<TerminalRefundQuerySort> sort;
    private final Map<String, Object> additionalProperties;

    private TerminalRefundQuery(Optional<TerminalRefundQueryFilter> filter, Optional<TerminalRefundQuerySort> sort, Map<String, Object> additionalProperties) {
        this.filter = filter;
        this.sort = sort;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="filter")
    public Optional<TerminalRefundQueryFilter> getFilter() {
        return this.filter;
    }

    @JsonProperty(value="sort")
    public Optional<TerminalRefundQuerySort> getSort() {
        return this.sort;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TerminalRefundQuery && this.equalTo((TerminalRefundQuery)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TerminalRefundQuery other) {
        return this.filter.equals(other.filter) && this.sort.equals(other.sort);
    }

    public int hashCode() {
        return Objects.hash(this.filter, this.sort);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<TerminalRefundQueryFilter> filter = Optional.empty();
        private Optional<TerminalRefundQuerySort> sort = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(TerminalRefundQuery other) {
            this.filter(other.getFilter());
            this.sort(other.getSort());
            return this;
        }

        @JsonSetter(value="filter", nulls=Nulls.SKIP)
        public Builder filter(Optional<TerminalRefundQueryFilter> filter) {
            this.filter = filter;
            return this;
        }

        public Builder filter(TerminalRefundQueryFilter filter) {
            this.filter = Optional.ofNullable(filter);
            return this;
        }

        @JsonSetter(value="sort", nulls=Nulls.SKIP)
        public Builder sort(Optional<TerminalRefundQuerySort> sort) {
            this.sort = sort;
            return this;
        }

        public Builder sort(TerminalRefundQuerySort sort) {
            this.sort = Optional.ofNullable(sort);
            return this;
        }

        public TerminalRefundQuery build() {
            return new TerminalRefundQuery(this.filter, this.sort, this.additionalProperties);
        }
    }
}

