/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.ActionCancelReason;
import com.squareup.square.types.CheckoutOptionsPaymentType;
import com.squareup.square.types.DeviceCheckoutOptions;
import com.squareup.square.types.Money;
import com.squareup.square.types.PaymentOptions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TerminalCheckout {
    private final Optional<String> id;
    private final Money amountMoney;
    private final Optional<String> referenceId;
    private final Optional<String> note;
    private final Optional<String> orderId;
    private final Optional<PaymentOptions> paymentOptions;
    private final DeviceCheckoutOptions deviceOptions;
    private final Optional<String> deadlineDuration;
    private final Optional<String> status;
    private final Optional<ActionCancelReason> cancelReason;
    private final Optional<List<String>> paymentIds;
    private final Optional<String> createdAt;
    private final Optional<String> updatedAt;
    private final Optional<String> appId;
    private final Optional<String> locationId;
    private final Optional<CheckoutOptionsPaymentType> paymentType;
    private final Optional<String> teamMemberId;
    private final Optional<String> customerId;
    private final Optional<Money> appFeeMoney;
    private final Optional<String> statementDescriptionIdentifier;
    private final Optional<Money> tipMoney;
    private final Map<String, Object> additionalProperties;

    private TerminalCheckout(Optional<String> id, Money amountMoney, Optional<String> referenceId, Optional<String> note, Optional<String> orderId, Optional<PaymentOptions> paymentOptions, DeviceCheckoutOptions deviceOptions, Optional<String> deadlineDuration, Optional<String> status, Optional<ActionCancelReason> cancelReason, Optional<List<String>> paymentIds, Optional<String> createdAt, Optional<String> updatedAt, Optional<String> appId, Optional<String> locationId, Optional<CheckoutOptionsPaymentType> paymentType, Optional<String> teamMemberId, Optional<String> customerId, Optional<Money> appFeeMoney, Optional<String> statementDescriptionIdentifier, Optional<Money> tipMoney, Map<String, Object> additionalProperties) {
        this.id = id;
        this.amountMoney = amountMoney;
        this.referenceId = referenceId;
        this.note = note;
        this.orderId = orderId;
        this.paymentOptions = paymentOptions;
        this.deviceOptions = deviceOptions;
        this.deadlineDuration = deadlineDuration;
        this.status = status;
        this.cancelReason = cancelReason;
        this.paymentIds = paymentIds;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.appId = appId;
        this.locationId = locationId;
        this.paymentType = paymentType;
        this.teamMemberId = teamMemberId;
        this.customerId = customerId;
        this.appFeeMoney = appFeeMoney;
        this.statementDescriptionIdentifier = statementDescriptionIdentifier;
        this.tipMoney = tipMoney;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="amount_money")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    @JsonIgnore
    public Optional<String> getReferenceId() {
        if (this.referenceId == null) {
            return Optional.empty();
        }
        return this.referenceId;
    }

    @JsonIgnore
    public Optional<String> getNote() {
        if (this.note == null) {
            return Optional.empty();
        }
        return this.note;
    }

    @JsonIgnore
    public Optional<String> getOrderId() {
        if (this.orderId == null) {
            return Optional.empty();
        }
        return this.orderId;
    }

    @JsonProperty(value="payment_options")
    public Optional<PaymentOptions> getPaymentOptions() {
        return this.paymentOptions;
    }

    @JsonProperty(value="device_options")
    public DeviceCheckoutOptions getDeviceOptions() {
        return this.deviceOptions;
    }

    @JsonIgnore
    public Optional<String> getDeadlineDuration() {
        if (this.deadlineDuration == null) {
            return Optional.empty();
        }
        return this.deadlineDuration;
    }

    @JsonProperty(value="status")
    public Optional<String> getStatus() {
        return this.status;
    }

    @JsonProperty(value="cancel_reason")
    public Optional<ActionCancelReason> getCancelReason() {
        return this.cancelReason;
    }

    @JsonProperty(value="payment_ids")
    public Optional<List<String>> getPaymentIds() {
        return this.paymentIds;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<String> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="app_id")
    public Optional<String> getAppId() {
        return this.appId;
    }

    @JsonProperty(value="location_id")
    public Optional<String> getLocationId() {
        return this.locationId;
    }

    @JsonProperty(value="payment_type")
    public Optional<CheckoutOptionsPaymentType> getPaymentType() {
        return this.paymentType;
    }

    @JsonIgnore
    public Optional<String> getTeamMemberId() {
        if (this.teamMemberId == null) {
            return Optional.empty();
        }
        return this.teamMemberId;
    }

    @JsonIgnore
    public Optional<String> getCustomerId() {
        if (this.customerId == null) {
            return Optional.empty();
        }
        return this.customerId;
    }

    @JsonProperty(value="app_fee_money")
    public Optional<Money> getAppFeeMoney() {
        return this.appFeeMoney;
    }

    @JsonIgnore
    public Optional<String> getStatementDescriptionIdentifier() {
        if (this.statementDescriptionIdentifier == null) {
            return Optional.empty();
        }
        return this.statementDescriptionIdentifier;
    }

    @JsonProperty(value="tip_money")
    public Optional<Money> getTipMoney() {
        return this.tipMoney;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="reference_id")
    private Optional<String> _getReferenceId() {
        return this.referenceId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="note")
    private Optional<String> _getNote() {
        return this.note;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="order_id")
    private Optional<String> _getOrderId() {
        return this.orderId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="deadline_duration")
    private Optional<String> _getDeadlineDuration() {
        return this.deadlineDuration;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="team_member_id")
    private Optional<String> _getTeamMemberId() {
        return this.teamMemberId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="customer_id")
    private Optional<String> _getCustomerId() {
        return this.customerId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="statement_description_identifier")
    private Optional<String> _getStatementDescriptionIdentifier() {
        return this.statementDescriptionIdentifier;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TerminalCheckout && this.equalTo((TerminalCheckout)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TerminalCheckout other) {
        return this.id.equals(other.id) && this.amountMoney.equals(other.amountMoney) && this.referenceId.equals(other.referenceId) && this.note.equals(other.note) && this.orderId.equals(other.orderId) && this.paymentOptions.equals(other.paymentOptions) && this.deviceOptions.equals(other.deviceOptions) && this.deadlineDuration.equals(other.deadlineDuration) && this.status.equals(other.status) && this.cancelReason.equals(other.cancelReason) && this.paymentIds.equals(other.paymentIds) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.appId.equals(other.appId) && this.locationId.equals(other.locationId) && this.paymentType.equals(other.paymentType) && this.teamMemberId.equals(other.teamMemberId) && this.customerId.equals(other.customerId) && this.appFeeMoney.equals(other.appFeeMoney) && this.statementDescriptionIdentifier.equals(other.statementDescriptionIdentifier) && this.tipMoney.equals(other.tipMoney);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.amountMoney, this.referenceId, this.note, this.orderId, this.paymentOptions, this.deviceOptions, this.deadlineDuration, this.status, this.cancelReason, this.paymentIds, this.createdAt, this.updatedAt, this.appId, this.locationId, this.paymentType, this.teamMemberId, this.customerId, this.appFeeMoney, this.statementDescriptionIdentifier, this.tipMoney);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AmountMoneyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AmountMoneyStage,
    DeviceOptionsStage,
    _FinalStage {
        private Money amountMoney;
        private DeviceCheckoutOptions deviceOptions;
        private Optional<Money> tipMoney = Optional.empty();
        private Optional<String> statementDescriptionIdentifier = Optional.empty();
        private Optional<Money> appFeeMoney = Optional.empty();
        private Optional<String> customerId = Optional.empty();
        private Optional<String> teamMemberId = Optional.empty();
        private Optional<CheckoutOptionsPaymentType> paymentType = Optional.empty();
        private Optional<String> locationId = Optional.empty();
        private Optional<String> appId = Optional.empty();
        private Optional<String> updatedAt = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<List<String>> paymentIds = Optional.empty();
        private Optional<ActionCancelReason> cancelReason = Optional.empty();
        private Optional<String> status = Optional.empty();
        private Optional<String> deadlineDuration = Optional.empty();
        private Optional<PaymentOptions> paymentOptions = Optional.empty();
        private Optional<String> orderId = Optional.empty();
        private Optional<String> note = Optional.empty();
        private Optional<String> referenceId = Optional.empty();
        private Optional<String> id = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(TerminalCheckout other) {
            this.id(other.getId());
            this.amountMoney(other.getAmountMoney());
            this.referenceId(other.getReferenceId());
            this.note(other.getNote());
            this.orderId(other.getOrderId());
            this.paymentOptions(other.getPaymentOptions());
            this.deviceOptions(other.getDeviceOptions());
            this.deadlineDuration(other.getDeadlineDuration());
            this.status(other.getStatus());
            this.cancelReason(other.getCancelReason());
            this.paymentIds(other.getPaymentIds());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.appId(other.getAppId());
            this.locationId(other.getLocationId());
            this.paymentType(other.getPaymentType());
            this.teamMemberId(other.getTeamMemberId());
            this.customerId(other.getCustomerId());
            this.appFeeMoney(other.getAppFeeMoney());
            this.statementDescriptionIdentifier(other.getStatementDescriptionIdentifier());
            this.tipMoney(other.getTipMoney());
            return this;
        }

        @Override
        @JsonSetter(value="amount_money")
        public DeviceOptionsStage amountMoney(@NotNull Money amountMoney) {
            this.amountMoney = Objects.requireNonNull(amountMoney, "amountMoney must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="device_options")
        public _FinalStage deviceOptions(@NotNull DeviceCheckoutOptions deviceOptions) {
            this.deviceOptions = Objects.requireNonNull(deviceOptions, "deviceOptions must not be null");
            return this;
        }

        @Override
        public _FinalStage tipMoney(Money tipMoney) {
            this.tipMoney = Optional.ofNullable(tipMoney);
            return this;
        }

        @Override
        @JsonSetter(value="tip_money", nulls=Nulls.SKIP)
        public _FinalStage tipMoney(Optional<Money> tipMoney) {
            this.tipMoney = tipMoney;
            return this;
        }

        @Override
        public _FinalStage statementDescriptionIdentifier(Nullable<String> statementDescriptionIdentifier) {
            this.statementDescriptionIdentifier = statementDescriptionIdentifier.isNull() ? null : (statementDescriptionIdentifier.isEmpty() ? Optional.empty() : Optional.of(statementDescriptionIdentifier.get()));
            return this;
        }

        @Override
        public _FinalStage statementDescriptionIdentifier(String statementDescriptionIdentifier) {
            this.statementDescriptionIdentifier = Optional.ofNullable(statementDescriptionIdentifier);
            return this;
        }

        @Override
        @JsonSetter(value="statement_description_identifier", nulls=Nulls.SKIP)
        public _FinalStage statementDescriptionIdentifier(Optional<String> statementDescriptionIdentifier) {
            this.statementDescriptionIdentifier = statementDescriptionIdentifier;
            return this;
        }

        @Override
        public _FinalStage appFeeMoney(Money appFeeMoney) {
            this.appFeeMoney = Optional.ofNullable(appFeeMoney);
            return this;
        }

        @Override
        @JsonSetter(value="app_fee_money", nulls=Nulls.SKIP)
        public _FinalStage appFeeMoney(Optional<Money> appFeeMoney) {
            this.appFeeMoney = appFeeMoney;
            return this;
        }

        @Override
        public _FinalStage customerId(Nullable<String> customerId) {
            this.customerId = customerId.isNull() ? null : (customerId.isEmpty() ? Optional.empty() : Optional.of(customerId.get()));
            return this;
        }

        @Override
        public _FinalStage customerId(String customerId) {
            this.customerId = Optional.ofNullable(customerId);
            return this;
        }

        @Override
        @JsonSetter(value="customer_id", nulls=Nulls.SKIP)
        public _FinalStage customerId(Optional<String> customerId) {
            this.customerId = customerId;
            return this;
        }

        @Override
        public _FinalStage teamMemberId(Nullable<String> teamMemberId) {
            this.teamMemberId = teamMemberId.isNull() ? null : (teamMemberId.isEmpty() ? Optional.empty() : Optional.of(teamMemberId.get()));
            return this;
        }

        @Override
        public _FinalStage teamMemberId(String teamMemberId) {
            this.teamMemberId = Optional.ofNullable(teamMemberId);
            return this;
        }

        @Override
        @JsonSetter(value="team_member_id", nulls=Nulls.SKIP)
        public _FinalStage teamMemberId(Optional<String> teamMemberId) {
            this.teamMemberId = teamMemberId;
            return this;
        }

        @Override
        public _FinalStage paymentType(CheckoutOptionsPaymentType paymentType) {
            this.paymentType = Optional.ofNullable(paymentType);
            return this;
        }

        @Override
        @JsonSetter(value="payment_type", nulls=Nulls.SKIP)
        public _FinalStage paymentType(Optional<CheckoutOptionsPaymentType> paymentType) {
            this.paymentType = paymentType;
            return this;
        }

        @Override
        public _FinalStage locationId(String locationId) {
            this.locationId = Optional.ofNullable(locationId);
            return this;
        }

        @Override
        @JsonSetter(value="location_id", nulls=Nulls.SKIP)
        public _FinalStage locationId(Optional<String> locationId) {
            this.locationId = locationId;
            return this;
        }

        @Override
        public _FinalStage appId(String appId) {
            this.appId = Optional.ofNullable(appId);
            return this;
        }

        @Override
        @JsonSetter(value="app_id", nulls=Nulls.SKIP)
        public _FinalStage appId(Optional<String> appId) {
            this.appId = appId;
            return this;
        }

        @Override
        public _FinalStage updatedAt(String updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @Override
        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public _FinalStage updatedAt(Optional<String> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public _FinalStage createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @Override
        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public _FinalStage createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public _FinalStage paymentIds(List<String> paymentIds) {
            this.paymentIds = Optional.ofNullable(paymentIds);
            return this;
        }

        @Override
        @JsonSetter(value="payment_ids", nulls=Nulls.SKIP)
        public _FinalStage paymentIds(Optional<List<String>> paymentIds) {
            this.paymentIds = paymentIds;
            return this;
        }

        @Override
        public _FinalStage cancelReason(ActionCancelReason cancelReason) {
            this.cancelReason = Optional.ofNullable(cancelReason);
            return this;
        }

        @Override
        @JsonSetter(value="cancel_reason", nulls=Nulls.SKIP)
        public _FinalStage cancelReason(Optional<ActionCancelReason> cancelReason) {
            this.cancelReason = cancelReason;
            return this;
        }

        @Override
        public _FinalStage status(String status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @Override
        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public _FinalStage status(Optional<String> status) {
            this.status = status;
            return this;
        }

        @Override
        public _FinalStage deadlineDuration(Nullable<String> deadlineDuration) {
            this.deadlineDuration = deadlineDuration.isNull() ? null : (deadlineDuration.isEmpty() ? Optional.empty() : Optional.of(deadlineDuration.get()));
            return this;
        }

        @Override
        public _FinalStage deadlineDuration(String deadlineDuration) {
            this.deadlineDuration = Optional.ofNullable(deadlineDuration);
            return this;
        }

        @Override
        @JsonSetter(value="deadline_duration", nulls=Nulls.SKIP)
        public _FinalStage deadlineDuration(Optional<String> deadlineDuration) {
            this.deadlineDuration = deadlineDuration;
            return this;
        }

        @Override
        public _FinalStage paymentOptions(PaymentOptions paymentOptions) {
            this.paymentOptions = Optional.ofNullable(paymentOptions);
            return this;
        }

        @Override
        @JsonSetter(value="payment_options", nulls=Nulls.SKIP)
        public _FinalStage paymentOptions(Optional<PaymentOptions> paymentOptions) {
            this.paymentOptions = paymentOptions;
            return this;
        }

        @Override
        public _FinalStage orderId(Nullable<String> orderId) {
            this.orderId = orderId.isNull() ? null : (orderId.isEmpty() ? Optional.empty() : Optional.of(orderId.get()));
            return this;
        }

        @Override
        public _FinalStage orderId(String orderId) {
            this.orderId = Optional.ofNullable(orderId);
            return this;
        }

        @Override
        @JsonSetter(value="order_id", nulls=Nulls.SKIP)
        public _FinalStage orderId(Optional<String> orderId) {
            this.orderId = orderId;
            return this;
        }

        @Override
        public _FinalStage note(Nullable<String> note) {
            this.note = note.isNull() ? null : (note.isEmpty() ? Optional.empty() : Optional.of(note.get()));
            return this;
        }

        @Override
        public _FinalStage note(String note) {
            this.note = Optional.ofNullable(note);
            return this;
        }

        @Override
        @JsonSetter(value="note", nulls=Nulls.SKIP)
        public _FinalStage note(Optional<String> note) {
            this.note = note;
            return this;
        }

        @Override
        public _FinalStage referenceId(Nullable<String> referenceId) {
            this.referenceId = referenceId.isNull() ? null : (referenceId.isEmpty() ? Optional.empty() : Optional.of(referenceId.get()));
            return this;
        }

        @Override
        public _FinalStage referenceId(String referenceId) {
            this.referenceId = Optional.ofNullable(referenceId);
            return this;
        }

        @Override
        @JsonSetter(value="reference_id", nulls=Nulls.SKIP)
        public _FinalStage referenceId(Optional<String> referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        @Override
        public _FinalStage id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @Override
        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public _FinalStage id(Optional<String> id) {
            this.id = id;
            return this;
        }

        @Override
        public TerminalCheckout build() {
            return new TerminalCheckout(this.id, this.amountMoney, this.referenceId, this.note, this.orderId, this.paymentOptions, this.deviceOptions, this.deadlineDuration, this.status, this.cancelReason, this.paymentIds, this.createdAt, this.updatedAt, this.appId, this.locationId, this.paymentType, this.teamMemberId, this.customerId, this.appFeeMoney, this.statementDescriptionIdentifier, this.tipMoney, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public TerminalCheckout build();

        public _FinalStage id(Optional<String> var1);

        public _FinalStage id(String var1);

        public _FinalStage referenceId(Optional<String> var1);

        public _FinalStage referenceId(String var1);

        public _FinalStage referenceId(Nullable<String> var1);

        public _FinalStage note(Optional<String> var1);

        public _FinalStage note(String var1);

        public _FinalStage note(Nullable<String> var1);

        public _FinalStage orderId(Optional<String> var1);

        public _FinalStage orderId(String var1);

        public _FinalStage orderId(Nullable<String> var1);

        public _FinalStage paymentOptions(Optional<PaymentOptions> var1);

        public _FinalStage paymentOptions(PaymentOptions var1);

        public _FinalStage deadlineDuration(Optional<String> var1);

        public _FinalStage deadlineDuration(String var1);

        public _FinalStage deadlineDuration(Nullable<String> var1);

        public _FinalStage status(Optional<String> var1);

        public _FinalStage status(String var1);

        public _FinalStage cancelReason(Optional<ActionCancelReason> var1);

        public _FinalStage cancelReason(ActionCancelReason var1);

        public _FinalStage paymentIds(Optional<List<String>> var1);

        public _FinalStage paymentIds(List<String> var1);

        public _FinalStage createdAt(Optional<String> var1);

        public _FinalStage createdAt(String var1);

        public _FinalStage updatedAt(Optional<String> var1);

        public _FinalStage updatedAt(String var1);

        public _FinalStage appId(Optional<String> var1);

        public _FinalStage appId(String var1);

        public _FinalStage locationId(Optional<String> var1);

        public _FinalStage locationId(String var1);

        public _FinalStage paymentType(Optional<CheckoutOptionsPaymentType> var1);

        public _FinalStage paymentType(CheckoutOptionsPaymentType var1);

        public _FinalStage teamMemberId(Optional<String> var1);

        public _FinalStage teamMemberId(String var1);

        public _FinalStage teamMemberId(Nullable<String> var1);

        public _FinalStage customerId(Optional<String> var1);

        public _FinalStage customerId(String var1);

        public _FinalStage customerId(Nullable<String> var1);

        public _FinalStage appFeeMoney(Optional<Money> var1);

        public _FinalStage appFeeMoney(Money var1);

        public _FinalStage statementDescriptionIdentifier(Optional<String> var1);

        public _FinalStage statementDescriptionIdentifier(String var1);

        public _FinalStage statementDescriptionIdentifier(Nullable<String> var1);

        public _FinalStage tipMoney(Optional<Money> var1);

        public _FinalStage tipMoney(Money var1);
    }

    public static interface DeviceOptionsStage {
        public _FinalStage deviceOptions(@NotNull DeviceCheckoutOptions var1);
    }

    public static interface AmountMoneyStage {
        public DeviceOptionsStage amountMoney(@NotNull Money var1);

        public Builder from(TerminalCheckout var1);
    }
}

