/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TenderCashDetails {
    private final Optional<Money> buyerTenderedMoney;
    private final Optional<Money> changeBackMoney;
    private final Map<String, Object> additionalProperties;

    private TenderCashDetails(Optional<Money> buyerTenderedMoney, Optional<Money> changeBackMoney, Map<String, Object> additionalProperties) {
        this.buyerTenderedMoney = buyerTenderedMoney;
        this.changeBackMoney = changeBackMoney;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="buyer_tendered_money")
    public Optional<Money> getBuyerTenderedMoney() {
        return this.buyerTenderedMoney;
    }

    @JsonProperty(value="change_back_money")
    public Optional<Money> getChangeBackMoney() {
        return this.changeBackMoney;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TenderCashDetails && this.equalTo((TenderCashDetails)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TenderCashDetails other) {
        return this.buyerTenderedMoney.equals(other.buyerTenderedMoney) && this.changeBackMoney.equals(other.changeBackMoney);
    }

    public int hashCode() {
        return Objects.hash(this.buyerTenderedMoney, this.changeBackMoney);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Money> buyerTenderedMoney = Optional.empty();
        private Optional<Money> changeBackMoney = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(TenderCashDetails other) {
            this.buyerTenderedMoney(other.getBuyerTenderedMoney());
            this.changeBackMoney(other.getChangeBackMoney());
            return this;
        }

        @JsonSetter(value="buyer_tendered_money", nulls=Nulls.SKIP)
        public Builder buyerTenderedMoney(Optional<Money> buyerTenderedMoney) {
            this.buyerTenderedMoney = buyerTenderedMoney;
            return this;
        }

        public Builder buyerTenderedMoney(Money buyerTenderedMoney) {
            this.buyerTenderedMoney = Optional.ofNullable(buyerTenderedMoney);
            return this;
        }

        @JsonSetter(value="change_back_money", nulls=Nulls.SKIP)
        public Builder changeBackMoney(Optional<Money> changeBackMoney) {
            this.changeBackMoney = changeBackMoney;
            return this;
        }

        public Builder changeBackMoney(Money changeBackMoney) {
            this.changeBackMoney = Optional.ofNullable(changeBackMoney);
            return this;
        }

        public TenderCashDetails build() {
            return new TenderCashDetails(this.buyerTenderedMoney, this.changeBackMoney, this.additionalProperties);
        }
    }
}

