/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.AdditionalRecipient;
import com.squareup.square.types.Money;
import com.squareup.square.types.TenderBankAccountDetails;
import com.squareup.square.types.TenderBuyNowPayLaterDetails;
import com.squareup.square.types.TenderCardDetails;
import com.squareup.square.types.TenderCashDetails;
import com.squareup.square.types.TenderSquareAccountDetails;
import com.squareup.square.types.TenderType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Tender {
    private final Optional<String> id;
    private final Optional<String> locationId;
    private final Optional<String> transactionId;
    private final Optional<String> createdAt;
    private final Optional<String> note;
    private final Optional<Money> amountMoney;
    private final Optional<Money> tipMoney;
    private final Optional<Money> processingFeeMoney;
    private final Optional<String> customerId;
    private final TenderType type;
    private final Optional<TenderCardDetails> cardDetails;
    private final Optional<TenderCashDetails> cashDetails;
    private final Optional<TenderBankAccountDetails> bankAccountDetails;
    private final Optional<TenderBuyNowPayLaterDetails> buyNowPayLaterDetails;
    private final Optional<TenderSquareAccountDetails> squareAccountDetails;
    private final Optional<List<AdditionalRecipient>> additionalRecipients;
    private final Optional<String> paymentId;
    private final Map<String, Object> additionalProperties;

    private Tender(Optional<String> id, Optional<String> locationId, Optional<String> transactionId, Optional<String> createdAt, Optional<String> note, Optional<Money> amountMoney, Optional<Money> tipMoney, Optional<Money> processingFeeMoney, Optional<String> customerId, TenderType type, Optional<TenderCardDetails> cardDetails, Optional<TenderCashDetails> cashDetails, Optional<TenderBankAccountDetails> bankAccountDetails, Optional<TenderBuyNowPayLaterDetails> buyNowPayLaterDetails, Optional<TenderSquareAccountDetails> squareAccountDetails, Optional<List<AdditionalRecipient>> additionalRecipients, Optional<String> paymentId, Map<String, Object> additionalProperties) {
        this.id = id;
        this.locationId = locationId;
        this.transactionId = transactionId;
        this.createdAt = createdAt;
        this.note = note;
        this.amountMoney = amountMoney;
        this.tipMoney = tipMoney;
        this.processingFeeMoney = processingFeeMoney;
        this.customerId = customerId;
        this.type = type;
        this.cardDetails = cardDetails;
        this.cashDetails = cashDetails;
        this.bankAccountDetails = bankAccountDetails;
        this.buyNowPayLaterDetails = buyNowPayLaterDetails;
        this.squareAccountDetails = squareAccountDetails;
        this.additionalRecipients = additionalRecipients;
        this.paymentId = paymentId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> getLocationId() {
        if (this.locationId == null) {
            return Optional.empty();
        }
        return this.locationId;
    }

    @JsonIgnore
    public Optional<String> getTransactionId() {
        if (this.transactionId == null) {
            return Optional.empty();
        }
        return this.transactionId;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonIgnore
    public Optional<String> getNote() {
        if (this.note == null) {
            return Optional.empty();
        }
        return this.note;
    }

    @JsonProperty(value="amount_money")
    public Optional<Money> getAmountMoney() {
        return this.amountMoney;
    }

    @JsonProperty(value="tip_money")
    public Optional<Money> getTipMoney() {
        return this.tipMoney;
    }

    @JsonProperty(value="processing_fee_money")
    public Optional<Money> getProcessingFeeMoney() {
        return this.processingFeeMoney;
    }

    @JsonIgnore
    public Optional<String> getCustomerId() {
        if (this.customerId == null) {
            return Optional.empty();
        }
        return this.customerId;
    }

    @JsonProperty(value="type")
    public TenderType getType() {
        return this.type;
    }

    @JsonProperty(value="card_details")
    public Optional<TenderCardDetails> getCardDetails() {
        return this.cardDetails;
    }

    @JsonProperty(value="cash_details")
    public Optional<TenderCashDetails> getCashDetails() {
        return this.cashDetails;
    }

    @JsonProperty(value="bank_account_details")
    public Optional<TenderBankAccountDetails> getBankAccountDetails() {
        return this.bankAccountDetails;
    }

    @JsonProperty(value="buy_now_pay_later_details")
    public Optional<TenderBuyNowPayLaterDetails> getBuyNowPayLaterDetails() {
        return this.buyNowPayLaterDetails;
    }

    @JsonProperty(value="square_account_details")
    public Optional<TenderSquareAccountDetails> getSquareAccountDetails() {
        return this.squareAccountDetails;
    }

    @JsonIgnore
    public Optional<List<AdditionalRecipient>> getAdditionalRecipients() {
        if (this.additionalRecipients == null) {
            return Optional.empty();
        }
        return this.additionalRecipients;
    }

    @JsonIgnore
    public Optional<String> getPaymentId() {
        if (this.paymentId == null) {
            return Optional.empty();
        }
        return this.paymentId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location_id")
    private Optional<String> _getLocationId() {
        return this.locationId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="transaction_id")
    private Optional<String> _getTransactionId() {
        return this.transactionId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="note")
    private Optional<String> _getNote() {
        return this.note;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="customer_id")
    private Optional<String> _getCustomerId() {
        return this.customerId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="additional_recipients")
    private Optional<List<AdditionalRecipient>> _getAdditionalRecipients() {
        return this.additionalRecipients;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="payment_id")
    private Optional<String> _getPaymentId() {
        return this.paymentId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Tender && this.equalTo((Tender)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Tender other) {
        return this.id.equals(other.id) && this.locationId.equals(other.locationId) && this.transactionId.equals(other.transactionId) && this.createdAt.equals(other.createdAt) && this.note.equals(other.note) && this.amountMoney.equals(other.amountMoney) && this.tipMoney.equals(other.tipMoney) && this.processingFeeMoney.equals(other.processingFeeMoney) && this.customerId.equals(other.customerId) && this.type.equals(other.type) && this.cardDetails.equals(other.cardDetails) && this.cashDetails.equals(other.cashDetails) && this.bankAccountDetails.equals(other.bankAccountDetails) && this.buyNowPayLaterDetails.equals(other.buyNowPayLaterDetails) && this.squareAccountDetails.equals(other.squareAccountDetails) && this.additionalRecipients.equals(other.additionalRecipients) && this.paymentId.equals(other.paymentId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.locationId, this.transactionId, this.createdAt, this.note, this.amountMoney, this.tipMoney, this.processingFeeMoney, this.customerId, this.type, this.cardDetails, this.cashDetails, this.bankAccountDetails, this.buyNowPayLaterDetails, this.squareAccountDetails, this.additionalRecipients, this.paymentId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TypeStage,
    _FinalStage {
        private TenderType type;
        private Optional<String> paymentId = Optional.empty();
        private Optional<List<AdditionalRecipient>> additionalRecipients = Optional.empty();
        private Optional<TenderSquareAccountDetails> squareAccountDetails = Optional.empty();
        private Optional<TenderBuyNowPayLaterDetails> buyNowPayLaterDetails = Optional.empty();
        private Optional<TenderBankAccountDetails> bankAccountDetails = Optional.empty();
        private Optional<TenderCashDetails> cashDetails = Optional.empty();
        private Optional<TenderCardDetails> cardDetails = Optional.empty();
        private Optional<String> customerId = Optional.empty();
        private Optional<Money> processingFeeMoney = Optional.empty();
        private Optional<Money> tipMoney = Optional.empty();
        private Optional<Money> amountMoney = Optional.empty();
        private Optional<String> note = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<String> transactionId = Optional.empty();
        private Optional<String> locationId = Optional.empty();
        private Optional<String> id = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Tender other) {
            this.id(other.getId());
            this.locationId(other.getLocationId());
            this.transactionId(other.getTransactionId());
            this.createdAt(other.getCreatedAt());
            this.note(other.getNote());
            this.amountMoney(other.getAmountMoney());
            this.tipMoney(other.getTipMoney());
            this.processingFeeMoney(other.getProcessingFeeMoney());
            this.customerId(other.getCustomerId());
            this.type(other.getType());
            this.cardDetails(other.getCardDetails());
            this.cashDetails(other.getCashDetails());
            this.bankAccountDetails(other.getBankAccountDetails());
            this.buyNowPayLaterDetails(other.getBuyNowPayLaterDetails());
            this.squareAccountDetails(other.getSquareAccountDetails());
            this.additionalRecipients(other.getAdditionalRecipients());
            this.paymentId(other.getPaymentId());
            return this;
        }

        @Override
        @JsonSetter(value="type")
        public _FinalStage type(@NotNull TenderType type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @Override
        public _FinalStage paymentId(Nullable<String> paymentId) {
            this.paymentId = paymentId.isNull() ? null : (paymentId.isEmpty() ? Optional.empty() : Optional.of(paymentId.get()));
            return this;
        }

        @Override
        public _FinalStage paymentId(String paymentId) {
            this.paymentId = Optional.ofNullable(paymentId);
            return this;
        }

        @Override
        @JsonSetter(value="payment_id", nulls=Nulls.SKIP)
        public _FinalStage paymentId(Optional<String> paymentId) {
            this.paymentId = paymentId;
            return this;
        }

        @Override
        public _FinalStage additionalRecipients(Nullable<List<AdditionalRecipient>> additionalRecipients) {
            this.additionalRecipients = additionalRecipients.isNull() ? null : (additionalRecipients.isEmpty() ? Optional.empty() : Optional.of(additionalRecipients.get()));
            return this;
        }

        @Override
        public _FinalStage additionalRecipients(List<AdditionalRecipient> additionalRecipients) {
            this.additionalRecipients = Optional.ofNullable(additionalRecipients);
            return this;
        }

        @Override
        @JsonSetter(value="additional_recipients", nulls=Nulls.SKIP)
        public _FinalStage additionalRecipients(Optional<List<AdditionalRecipient>> additionalRecipients) {
            this.additionalRecipients = additionalRecipients;
            return this;
        }

        @Override
        public _FinalStage squareAccountDetails(TenderSquareAccountDetails squareAccountDetails) {
            this.squareAccountDetails = Optional.ofNullable(squareAccountDetails);
            return this;
        }

        @Override
        @JsonSetter(value="square_account_details", nulls=Nulls.SKIP)
        public _FinalStage squareAccountDetails(Optional<TenderSquareAccountDetails> squareAccountDetails) {
            this.squareAccountDetails = squareAccountDetails;
            return this;
        }

        @Override
        public _FinalStage buyNowPayLaterDetails(TenderBuyNowPayLaterDetails buyNowPayLaterDetails) {
            this.buyNowPayLaterDetails = Optional.ofNullable(buyNowPayLaterDetails);
            return this;
        }

        @Override
        @JsonSetter(value="buy_now_pay_later_details", nulls=Nulls.SKIP)
        public _FinalStage buyNowPayLaterDetails(Optional<TenderBuyNowPayLaterDetails> buyNowPayLaterDetails) {
            this.buyNowPayLaterDetails = buyNowPayLaterDetails;
            return this;
        }

        @Override
        public _FinalStage bankAccountDetails(TenderBankAccountDetails bankAccountDetails) {
            this.bankAccountDetails = Optional.ofNullable(bankAccountDetails);
            return this;
        }

        @Override
        @JsonSetter(value="bank_account_details", nulls=Nulls.SKIP)
        public _FinalStage bankAccountDetails(Optional<TenderBankAccountDetails> bankAccountDetails) {
            this.bankAccountDetails = bankAccountDetails;
            return this;
        }

        @Override
        public _FinalStage cashDetails(TenderCashDetails cashDetails) {
            this.cashDetails = Optional.ofNullable(cashDetails);
            return this;
        }

        @Override
        @JsonSetter(value="cash_details", nulls=Nulls.SKIP)
        public _FinalStage cashDetails(Optional<TenderCashDetails> cashDetails) {
            this.cashDetails = cashDetails;
            return this;
        }

        @Override
        public _FinalStage cardDetails(TenderCardDetails cardDetails) {
            this.cardDetails = Optional.ofNullable(cardDetails);
            return this;
        }

        @Override
        @JsonSetter(value="card_details", nulls=Nulls.SKIP)
        public _FinalStage cardDetails(Optional<TenderCardDetails> cardDetails) {
            this.cardDetails = cardDetails;
            return this;
        }

        @Override
        public _FinalStage customerId(Nullable<String> customerId) {
            this.customerId = customerId.isNull() ? null : (customerId.isEmpty() ? Optional.empty() : Optional.of(customerId.get()));
            return this;
        }

        @Override
        public _FinalStage customerId(String customerId) {
            this.customerId = Optional.ofNullable(customerId);
            return this;
        }

        @Override
        @JsonSetter(value="customer_id", nulls=Nulls.SKIP)
        public _FinalStage customerId(Optional<String> customerId) {
            this.customerId = customerId;
            return this;
        }

        @Override
        public _FinalStage processingFeeMoney(Money processingFeeMoney) {
            this.processingFeeMoney = Optional.ofNullable(processingFeeMoney);
            return this;
        }

        @Override
        @JsonSetter(value="processing_fee_money", nulls=Nulls.SKIP)
        public _FinalStage processingFeeMoney(Optional<Money> processingFeeMoney) {
            this.processingFeeMoney = processingFeeMoney;
            return this;
        }

        @Override
        public _FinalStage tipMoney(Money tipMoney) {
            this.tipMoney = Optional.ofNullable(tipMoney);
            return this;
        }

        @Override
        @JsonSetter(value="tip_money", nulls=Nulls.SKIP)
        public _FinalStage tipMoney(Optional<Money> tipMoney) {
            this.tipMoney = tipMoney;
            return this;
        }

        @Override
        public _FinalStage amountMoney(Money amountMoney) {
            this.amountMoney = Optional.ofNullable(amountMoney);
            return this;
        }

        @Override
        @JsonSetter(value="amount_money", nulls=Nulls.SKIP)
        public _FinalStage amountMoney(Optional<Money> amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        @Override
        public _FinalStage note(Nullable<String> note) {
            this.note = note.isNull() ? null : (note.isEmpty() ? Optional.empty() : Optional.of(note.get()));
            return this;
        }

        @Override
        public _FinalStage note(String note) {
            this.note = Optional.ofNullable(note);
            return this;
        }

        @Override
        @JsonSetter(value="note", nulls=Nulls.SKIP)
        public _FinalStage note(Optional<String> note) {
            this.note = note;
            return this;
        }

        @Override
        public _FinalStage createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @Override
        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public _FinalStage createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public _FinalStage transactionId(Nullable<String> transactionId) {
            this.transactionId = transactionId.isNull() ? null : (transactionId.isEmpty() ? Optional.empty() : Optional.of(transactionId.get()));
            return this;
        }

        @Override
        public _FinalStage transactionId(String transactionId) {
            this.transactionId = Optional.ofNullable(transactionId);
            return this;
        }

        @Override
        @JsonSetter(value="transaction_id", nulls=Nulls.SKIP)
        public _FinalStage transactionId(Optional<String> transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        @Override
        public _FinalStage locationId(Nullable<String> locationId) {
            this.locationId = locationId.isNull() ? null : (locationId.isEmpty() ? Optional.empty() : Optional.of(locationId.get()));
            return this;
        }

        @Override
        public _FinalStage locationId(String locationId) {
            this.locationId = Optional.ofNullable(locationId);
            return this;
        }

        @Override
        @JsonSetter(value="location_id", nulls=Nulls.SKIP)
        public _FinalStage locationId(Optional<String> locationId) {
            this.locationId = locationId;
            return this;
        }

        @Override
        public _FinalStage id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @Override
        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public _FinalStage id(Optional<String> id) {
            this.id = id;
            return this;
        }

        @Override
        public Tender build() {
            return new Tender(this.id, this.locationId, this.transactionId, this.createdAt, this.note, this.amountMoney, this.tipMoney, this.processingFeeMoney, this.customerId, this.type, this.cardDetails, this.cashDetails, this.bankAccountDetails, this.buyNowPayLaterDetails, this.squareAccountDetails, this.additionalRecipients, this.paymentId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Tender build();

        public _FinalStage id(Optional<String> var1);

        public _FinalStage id(String var1);

        public _FinalStage locationId(Optional<String> var1);

        public _FinalStage locationId(String var1);

        public _FinalStage locationId(Nullable<String> var1);

        public _FinalStage transactionId(Optional<String> var1);

        public _FinalStage transactionId(String var1);

        public _FinalStage transactionId(Nullable<String> var1);

        public _FinalStage createdAt(Optional<String> var1);

        public _FinalStage createdAt(String var1);

        public _FinalStage note(Optional<String> var1);

        public _FinalStage note(String var1);

        public _FinalStage note(Nullable<String> var1);

        public _FinalStage amountMoney(Optional<Money> var1);

        public _FinalStage amountMoney(Money var1);

        public _FinalStage tipMoney(Optional<Money> var1);

        public _FinalStage tipMoney(Money var1);

        public _FinalStage processingFeeMoney(Optional<Money> var1);

        public _FinalStage processingFeeMoney(Money var1);

        public _FinalStage customerId(Optional<String> var1);

        public _FinalStage customerId(String var1);

        public _FinalStage customerId(Nullable<String> var1);

        public _FinalStage cardDetails(Optional<TenderCardDetails> var1);

        public _FinalStage cardDetails(TenderCardDetails var1);

        public _FinalStage cashDetails(Optional<TenderCashDetails> var1);

        public _FinalStage cashDetails(TenderCashDetails var1);

        public _FinalStage bankAccountDetails(Optional<TenderBankAccountDetails> var1);

        public _FinalStage bankAccountDetails(TenderBankAccountDetails var1);

        public _FinalStage buyNowPayLaterDetails(Optional<TenderBuyNowPayLaterDetails> var1);

        public _FinalStage buyNowPayLaterDetails(TenderBuyNowPayLaterDetails var1);

        public _FinalStage squareAccountDetails(Optional<TenderSquareAccountDetails> var1);

        public _FinalStage squareAccountDetails(TenderSquareAccountDetails var1);

        public _FinalStage additionalRecipients(Optional<List<AdditionalRecipient>> var1);

        public _FinalStage additionalRecipients(List<AdditionalRecipient> var1);

        public _FinalStage additionalRecipients(Nullable<List<AdditionalRecipient>> var1);

        public _FinalStage paymentId(Optional<String> var1);

        public _FinalStage paymentId(String var1);

        public _FinalStage paymentId(Nullable<String> var1);
    }

    public static interface TypeStage {
        public _FinalStage type(@NotNull TenderType var1);

        public Builder from(Tender var1);
    }
}

