/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TeamMemberWage {
    private final Optional<String> id;
    private final Optional<String> teamMemberId;
    private final Optional<String> title;
    private final Optional<Money> hourlyRate;
    private final Optional<String> jobId;
    private final Optional<Boolean> tipEligible;
    private final Map<String, Object> additionalProperties;

    private TeamMemberWage(Optional<String> id, Optional<String> teamMemberId, Optional<String> title, Optional<Money> hourlyRate, Optional<String> jobId, Optional<Boolean> tipEligible, Map<String, Object> additionalProperties) {
        this.id = id;
        this.teamMemberId = teamMemberId;
        this.title = title;
        this.hourlyRate = hourlyRate;
        this.jobId = jobId;
        this.tipEligible = tipEligible;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> getTeamMemberId() {
        if (this.teamMemberId == null) {
            return Optional.empty();
        }
        return this.teamMemberId;
    }

    @JsonIgnore
    public Optional<String> getTitle() {
        if (this.title == null) {
            return Optional.empty();
        }
        return this.title;
    }

    @JsonProperty(value="hourly_rate")
    public Optional<Money> getHourlyRate() {
        return this.hourlyRate;
    }

    @JsonIgnore
    public Optional<String> getJobId() {
        if (this.jobId == null) {
            return Optional.empty();
        }
        return this.jobId;
    }

    @JsonIgnore
    public Optional<Boolean> getTipEligible() {
        if (this.tipEligible == null) {
            return Optional.empty();
        }
        return this.tipEligible;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="team_member_id")
    private Optional<String> _getTeamMemberId() {
        return this.teamMemberId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="title")
    private Optional<String> _getTitle() {
        return this.title;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="job_id")
    private Optional<String> _getJobId() {
        return this.jobId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="tip_eligible")
    private Optional<Boolean> _getTipEligible() {
        return this.tipEligible;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TeamMemberWage && this.equalTo((TeamMemberWage)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TeamMemberWage other) {
        return this.id.equals(other.id) && this.teamMemberId.equals(other.teamMemberId) && this.title.equals(other.title) && this.hourlyRate.equals(other.hourlyRate) && this.jobId.equals(other.jobId) && this.tipEligible.equals(other.tipEligible);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.teamMemberId, this.title, this.hourlyRate, this.jobId, this.tipEligible);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> teamMemberId = Optional.empty();
        private Optional<String> title = Optional.empty();
        private Optional<Money> hourlyRate = Optional.empty();
        private Optional<String> jobId = Optional.empty();
        private Optional<Boolean> tipEligible = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(TeamMemberWage other) {
            this.id(other.getId());
            this.teamMemberId(other.getTeamMemberId());
            this.title(other.getTitle());
            this.hourlyRate(other.getHourlyRate());
            this.jobId(other.getJobId());
            this.tipEligible(other.getTipEligible());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="team_member_id", nulls=Nulls.SKIP)
        public Builder teamMemberId(Optional<String> teamMemberId) {
            this.teamMemberId = teamMemberId;
            return this;
        }

        public Builder teamMemberId(String teamMemberId) {
            this.teamMemberId = Optional.ofNullable(teamMemberId);
            return this;
        }

        public Builder teamMemberId(Nullable<String> teamMemberId) {
            this.teamMemberId = teamMemberId.isNull() ? null : (teamMemberId.isEmpty() ? Optional.empty() : Optional.of(teamMemberId.get()));
            return this;
        }

        @JsonSetter(value="title", nulls=Nulls.SKIP)
        public Builder title(Optional<String> title) {
            this.title = title;
            return this;
        }

        public Builder title(String title) {
            this.title = Optional.ofNullable(title);
            return this;
        }

        public Builder title(Nullable<String> title) {
            this.title = title.isNull() ? null : (title.isEmpty() ? Optional.empty() : Optional.of(title.get()));
            return this;
        }

        @JsonSetter(value="hourly_rate", nulls=Nulls.SKIP)
        public Builder hourlyRate(Optional<Money> hourlyRate) {
            this.hourlyRate = hourlyRate;
            return this;
        }

        public Builder hourlyRate(Money hourlyRate) {
            this.hourlyRate = Optional.ofNullable(hourlyRate);
            return this;
        }

        @JsonSetter(value="job_id", nulls=Nulls.SKIP)
        public Builder jobId(Optional<String> jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder jobId(String jobId) {
            this.jobId = Optional.ofNullable(jobId);
            return this;
        }

        public Builder jobId(Nullable<String> jobId) {
            this.jobId = jobId.isNull() ? null : (jobId.isEmpty() ? Optional.empty() : Optional.of(jobId.get()));
            return this;
        }

        @JsonSetter(value="tip_eligible", nulls=Nulls.SKIP)
        public Builder tipEligible(Optional<Boolean> tipEligible) {
            this.tipEligible = tipEligible;
            return this;
        }

        public Builder tipEligible(Boolean tipEligible) {
            this.tipEligible = Optional.ofNullable(tipEligible);
            return this;
        }

        public Builder tipEligible(Nullable<Boolean> tipEligible) {
            this.tipEligible = tipEligible.isNull() ? null : (tipEligible.isEmpty() ? Optional.empty() : Optional.of(tipEligible.get()));
            return this;
        }

        public TeamMemberWage build() {
            return new TeamMemberWage(this.id, this.teamMemberId, this.title, this.hourlyRate, this.jobId, this.tipEligible, this.additionalProperties);
        }
    }
}

