/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.TeamMember;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TeamMemberUpdatedEventObject {
    private final Optional<TeamMember> teamMember;
    private final Map<String, Object> additionalProperties;

    private TeamMemberUpdatedEventObject(Optional<TeamMember> teamMember, Map<String, Object> additionalProperties) {
        this.teamMember = teamMember;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="team_member")
    public Optional<TeamMember> getTeamMember() {
        return this.teamMember;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TeamMemberUpdatedEventObject && this.equalTo((TeamMemberUpdatedEventObject)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TeamMemberUpdatedEventObject other) {
        return this.teamMember.equals(other.teamMember);
    }

    public int hashCode() {
        return Objects.hash(this.teamMember);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<TeamMember> teamMember = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(TeamMemberUpdatedEventObject other) {
            this.teamMember(other.getTeamMember());
            return this;
        }

        @JsonSetter(value="team_member", nulls=Nulls.SKIP)
        public Builder teamMember(Optional<TeamMember> teamMember) {
            this.teamMember = teamMember;
            return this;
        }

        public Builder teamMember(TeamMember teamMember) {
            this.teamMember = Optional.ofNullable(teamMember);
            return this;
        }

        public TeamMemberUpdatedEventObject build() {
            return new TeamMemberUpdatedEventObject(this.teamMember, this.additionalProperties);
        }
    }
}

