/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class TaxInclusionType {
    public static final TaxInclusionType INCLUSIVE = new TaxInclusionType(Value.INCLUSIVE, "INCLUSIVE");
    public static final TaxInclusionType ADDITIVE = new TaxInclusionType(Value.ADDITIVE, "ADDITIVE");
    private final Value value;
    private final String string;

    TaxInclusionType(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof TaxInclusionType && this.string.equals(((TaxInclusionType)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case INCLUSIVE: {
                return visitor.visitInclusive();
            }
            case ADDITIVE: {
                return visitor.visitAdditive();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static TaxInclusionType valueOf(String value) {
        switch (value) {
            case "INCLUSIVE": {
                return INCLUSIVE;
            }
            case "ADDITIVE": {
                return ADDITIVE;
            }
        }
        return new TaxInclusionType(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitAdditive();

        public T visitInclusive();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        ADDITIVE,
        INCLUSIVE,
        UNKNOWN;

    }
}

