/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TaxIds {
    private final Optional<String> euVat;
    private final Optional<String> frSiret;
    private final Optional<String> frNaf;
    private final Optional<String> esNif;
    private final Optional<String> jpQii;
    private final Map<String, Object> additionalProperties;

    private TaxIds(Optional<String> euVat, Optional<String> frSiret, Optional<String> frNaf, Optional<String> esNif, Optional<String> jpQii, Map<String, Object> additionalProperties) {
        this.euVat = euVat;
        this.frSiret = frSiret;
        this.frNaf = frNaf;
        this.esNif = esNif;
        this.jpQii = jpQii;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="eu_vat")
    public Optional<String> getEuVat() {
        return this.euVat;
    }

    @JsonProperty(value="fr_siret")
    public Optional<String> getFrSiret() {
        return this.frSiret;
    }

    @JsonProperty(value="fr_naf")
    public Optional<String> getFrNaf() {
        return this.frNaf;
    }

    @JsonProperty(value="es_nif")
    public Optional<String> getEsNif() {
        return this.esNif;
    }

    @JsonProperty(value="jp_qii")
    public Optional<String> getJpQii() {
        return this.jpQii;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TaxIds && this.equalTo((TaxIds)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TaxIds other) {
        return this.euVat.equals(other.euVat) && this.frSiret.equals(other.frSiret) && this.frNaf.equals(other.frNaf) && this.esNif.equals(other.esNif) && this.jpQii.equals(other.jpQii);
    }

    public int hashCode() {
        return Objects.hash(this.euVat, this.frSiret, this.frNaf, this.esNif, this.jpQii);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> euVat = Optional.empty();
        private Optional<String> frSiret = Optional.empty();
        private Optional<String> frNaf = Optional.empty();
        private Optional<String> esNif = Optional.empty();
        private Optional<String> jpQii = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(TaxIds other) {
            this.euVat(other.getEuVat());
            this.frSiret(other.getFrSiret());
            this.frNaf(other.getFrNaf());
            this.esNif(other.getEsNif());
            this.jpQii(other.getJpQii());
            return this;
        }

        @JsonSetter(value="eu_vat", nulls=Nulls.SKIP)
        public Builder euVat(Optional<String> euVat) {
            this.euVat = euVat;
            return this;
        }

        public Builder euVat(String euVat) {
            this.euVat = Optional.ofNullable(euVat);
            return this;
        }

        @JsonSetter(value="fr_siret", nulls=Nulls.SKIP)
        public Builder frSiret(Optional<String> frSiret) {
            this.frSiret = frSiret;
            return this;
        }

        public Builder frSiret(String frSiret) {
            this.frSiret = Optional.ofNullable(frSiret);
            return this;
        }

        @JsonSetter(value="fr_naf", nulls=Nulls.SKIP)
        public Builder frNaf(Optional<String> frNaf) {
            this.frNaf = frNaf;
            return this;
        }

        public Builder frNaf(String frNaf) {
            this.frNaf = Optional.ofNullable(frNaf);
            return this;
        }

        @JsonSetter(value="es_nif", nulls=Nulls.SKIP)
        public Builder esNif(Optional<String> esNif) {
            this.esNif = esNif;
            return this;
        }

        public Builder esNif(String esNif) {
            this.esNif = Optional.ofNullable(esNif);
            return this;
        }

        @JsonSetter(value="jp_qii", nulls=Nulls.SKIP)
        public Builder jpQii(Optional<String> jpQii) {
            this.jpQii = jpQii;
            return this;
        }

        public Builder jpQii(String jpQii) {
            this.jpQii = Optional.ofNullable(jpQii);
            return this;
        }

        public TaxIds build() {
            return new TaxIds(this.euVat, this.frSiret, this.frNaf, this.esNif, this.jpQii, this.additionalProperties);
        }
    }
}

