/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Phase;
import com.squareup.square.types.SubscriptionActionType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SubscriptionAction {
    private final Optional<String> id;
    private final Optional<SubscriptionActionType> type;
    private final Optional<String> effectiveDate;
    private final Optional<Integer> monthlyBillingAnchorDate;
    private final Optional<List<Phase>> phases;
    private final Optional<String> newPlanVariationId;
    private final Map<String, Object> additionalProperties;

    private SubscriptionAction(Optional<String> id, Optional<SubscriptionActionType> type, Optional<String> effectiveDate, Optional<Integer> monthlyBillingAnchorDate, Optional<List<Phase>> phases, Optional<String> newPlanVariationId, Map<String, Object> additionalProperties) {
        this.id = id;
        this.type = type;
        this.effectiveDate = effectiveDate;
        this.monthlyBillingAnchorDate = monthlyBillingAnchorDate;
        this.phases = phases;
        this.newPlanVariationId = newPlanVariationId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="type")
    public Optional<SubscriptionActionType> getType() {
        return this.type;
    }

    @JsonIgnore
    public Optional<String> getEffectiveDate() {
        if (this.effectiveDate == null) {
            return Optional.empty();
        }
        return this.effectiveDate;
    }

    @JsonIgnore
    public Optional<Integer> getMonthlyBillingAnchorDate() {
        if (this.monthlyBillingAnchorDate == null) {
            return Optional.empty();
        }
        return this.monthlyBillingAnchorDate;
    }

    @JsonIgnore
    public Optional<List<Phase>> getPhases() {
        if (this.phases == null) {
            return Optional.empty();
        }
        return this.phases;
    }

    @JsonIgnore
    public Optional<String> getNewPlanVariationId() {
        if (this.newPlanVariationId == null) {
            return Optional.empty();
        }
        return this.newPlanVariationId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="effective_date")
    private Optional<String> _getEffectiveDate() {
        return this.effectiveDate;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="monthly_billing_anchor_date")
    private Optional<Integer> _getMonthlyBillingAnchorDate() {
        return this.monthlyBillingAnchorDate;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="phases")
    private Optional<List<Phase>> _getPhases() {
        return this.phases;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="new_plan_variation_id")
    private Optional<String> _getNewPlanVariationId() {
        return this.newPlanVariationId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SubscriptionAction && this.equalTo((SubscriptionAction)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SubscriptionAction other) {
        return this.id.equals(other.id) && this.type.equals(other.type) && this.effectiveDate.equals(other.effectiveDate) && this.monthlyBillingAnchorDate.equals(other.monthlyBillingAnchorDate) && this.phases.equals(other.phases) && this.newPlanVariationId.equals(other.newPlanVariationId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.type, this.effectiveDate, this.monthlyBillingAnchorDate, this.phases, this.newPlanVariationId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<SubscriptionActionType> type = Optional.empty();
        private Optional<String> effectiveDate = Optional.empty();
        private Optional<Integer> monthlyBillingAnchorDate = Optional.empty();
        private Optional<List<Phase>> phases = Optional.empty();
        private Optional<String> newPlanVariationId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SubscriptionAction other) {
            this.id(other.getId());
            this.type(other.getType());
            this.effectiveDate(other.getEffectiveDate());
            this.monthlyBillingAnchorDate(other.getMonthlyBillingAnchorDate());
            this.phases(other.getPhases());
            this.newPlanVariationId(other.getNewPlanVariationId());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<SubscriptionActionType> type) {
            this.type = type;
            return this;
        }

        public Builder type(SubscriptionActionType type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="effective_date", nulls=Nulls.SKIP)
        public Builder effectiveDate(Optional<String> effectiveDate) {
            this.effectiveDate = effectiveDate;
            return this;
        }

        public Builder effectiveDate(String effectiveDate) {
            this.effectiveDate = Optional.ofNullable(effectiveDate);
            return this;
        }

        public Builder effectiveDate(Nullable<String> effectiveDate) {
            this.effectiveDate = effectiveDate.isNull() ? null : (effectiveDate.isEmpty() ? Optional.empty() : Optional.of(effectiveDate.get()));
            return this;
        }

        @JsonSetter(value="monthly_billing_anchor_date", nulls=Nulls.SKIP)
        public Builder monthlyBillingAnchorDate(Optional<Integer> monthlyBillingAnchorDate) {
            this.monthlyBillingAnchorDate = monthlyBillingAnchorDate;
            return this;
        }

        public Builder monthlyBillingAnchorDate(Integer monthlyBillingAnchorDate) {
            this.monthlyBillingAnchorDate = Optional.ofNullable(monthlyBillingAnchorDate);
            return this;
        }

        public Builder monthlyBillingAnchorDate(Nullable<Integer> monthlyBillingAnchorDate) {
            this.monthlyBillingAnchorDate = monthlyBillingAnchorDate.isNull() ? null : (monthlyBillingAnchorDate.isEmpty() ? Optional.empty() : Optional.of(monthlyBillingAnchorDate.get()));
            return this;
        }

        @JsonSetter(value="phases", nulls=Nulls.SKIP)
        public Builder phases(Optional<List<Phase>> phases) {
            this.phases = phases;
            return this;
        }

        public Builder phases(List<Phase> phases) {
            this.phases = Optional.ofNullable(phases);
            return this;
        }

        public Builder phases(Nullable<List<Phase>> phases) {
            this.phases = phases.isNull() ? null : (phases.isEmpty() ? Optional.empty() : Optional.of(phases.get()));
            return this;
        }

        @JsonSetter(value="new_plan_variation_id", nulls=Nulls.SKIP)
        public Builder newPlanVariationId(Optional<String> newPlanVariationId) {
            this.newPlanVariationId = newPlanVariationId;
            return this;
        }

        public Builder newPlanVariationId(String newPlanVariationId) {
            this.newPlanVariationId = Optional.ofNullable(newPlanVariationId);
            return this;
        }

        public Builder newPlanVariationId(Nullable<String> newPlanVariationId) {
            this.newPlanVariationId = newPlanVariationId.isNull() ? null : (newPlanVariationId.isEmpty() ? Optional.empty() : Optional.of(newPlanVariationId.get()));
            return this;
        }

        public SubscriptionAction build() {
            return new SubscriptionAction(this.id, this.type, this.effectiveDate, this.monthlyBillingAnchorDate, this.phases, this.newPlanVariationId, this.additionalProperties);
        }
    }
}

