/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Dispute;
import com.squareup.square.types.Error;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SubmitEvidenceResponse {
    private final Optional<List<Error>> errors;
    private final Optional<Dispute> dispute;
    private final Map<String, Object> additionalProperties;

    private SubmitEvidenceResponse(Optional<List<Error>> errors, Optional<Dispute> dispute, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.dispute = dispute;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="dispute")
    public Optional<Dispute> getDispute() {
        return this.dispute;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SubmitEvidenceResponse && this.equalTo((SubmitEvidenceResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SubmitEvidenceResponse other) {
        return this.errors.equals(other.errors) && this.dispute.equals(other.dispute);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.dispute);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<Dispute> dispute = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SubmitEvidenceResponse other) {
            this.errors(other.getErrors());
            this.dispute(other.getDispute());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="dispute", nulls=Nulls.SKIP)
        public Builder dispute(Optional<Dispute> dispute) {
            this.dispute = dispute;
            return this;
        }

        public Builder dispute(Dispute dispute) {
            this.dispute = Optional.ofNullable(dispute);
            return this;
        }

        public SubmitEvidenceResponse build() {
            return new SubmitEvidenceResponse(this.errors, this.dispute, this.additionalProperties);
        }
    }
}

