/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.StandardUnitDescription;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class StandardUnitDescriptionGroup {
    private final Optional<List<StandardUnitDescription>> standardUnitDescriptions;
    private final Optional<String> languageCode;
    private final Map<String, Object> additionalProperties;

    private StandardUnitDescriptionGroup(Optional<List<StandardUnitDescription>> standardUnitDescriptions, Optional<String> languageCode, Map<String, Object> additionalProperties) {
        this.standardUnitDescriptions = standardUnitDescriptions;
        this.languageCode = languageCode;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<List<StandardUnitDescription>> getStandardUnitDescriptions() {
        if (this.standardUnitDescriptions == null) {
            return Optional.empty();
        }
        return this.standardUnitDescriptions;
    }

    @JsonIgnore
    public Optional<String> getLanguageCode() {
        if (this.languageCode == null) {
            return Optional.empty();
        }
        return this.languageCode;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="standard_unit_descriptions")
    private Optional<List<StandardUnitDescription>> _getStandardUnitDescriptions() {
        return this.standardUnitDescriptions;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="language_code")
    private Optional<String> _getLanguageCode() {
        return this.languageCode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof StandardUnitDescriptionGroup && this.equalTo((StandardUnitDescriptionGroup)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(StandardUnitDescriptionGroup other) {
        return this.standardUnitDescriptions.equals(other.standardUnitDescriptions) && this.languageCode.equals(other.languageCode);
    }

    public int hashCode() {
        return Objects.hash(this.standardUnitDescriptions, this.languageCode);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<StandardUnitDescription>> standardUnitDescriptions = Optional.empty();
        private Optional<String> languageCode = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(StandardUnitDescriptionGroup other) {
            this.standardUnitDescriptions(other.getStandardUnitDescriptions());
            this.languageCode(other.getLanguageCode());
            return this;
        }

        @JsonSetter(value="standard_unit_descriptions", nulls=Nulls.SKIP)
        public Builder standardUnitDescriptions(Optional<List<StandardUnitDescription>> standardUnitDescriptions) {
            this.standardUnitDescriptions = standardUnitDescriptions;
            return this;
        }

        public Builder standardUnitDescriptions(List<StandardUnitDescription> standardUnitDescriptions) {
            this.standardUnitDescriptions = Optional.ofNullable(standardUnitDescriptions);
            return this;
        }

        public Builder standardUnitDescriptions(Nullable<List<StandardUnitDescription>> standardUnitDescriptions) {
            this.standardUnitDescriptions = standardUnitDescriptions.isNull() ? null : (standardUnitDescriptions.isEmpty() ? Optional.empty() : Optional.of(standardUnitDescriptions.get()));
            return this;
        }

        @JsonSetter(value="language_code", nulls=Nulls.SKIP)
        public Builder languageCode(Optional<String> languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        public Builder languageCode(String languageCode) {
            this.languageCode = Optional.ofNullable(languageCode);
            return this;
        }

        public Builder languageCode(Nullable<String> languageCode) {
            this.languageCode = languageCode.isNull() ? null : (languageCode.isEmpty() ? Optional.empty() : Optional.of(languageCode.get()));
            return this;
        }

        public StandardUnitDescriptionGroup build() {
            return new StandardUnitDescriptionGroup(this.standardUnitDescriptions, this.languageCode, this.additionalProperties);
        }
    }
}

