/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.MeasurementUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class StandardUnitDescription {
    private final Optional<MeasurementUnit> unit;
    private final Optional<String> name;
    private final Optional<String> abbreviation;
    private final Map<String, Object> additionalProperties;

    private StandardUnitDescription(Optional<MeasurementUnit> unit, Optional<String> name, Optional<String> abbreviation, Map<String, Object> additionalProperties) {
        this.unit = unit;
        this.name = name;
        this.abbreviation = abbreviation;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="unit")
    public Optional<MeasurementUnit> getUnit() {
        return this.unit;
    }

    @JsonIgnore
    public Optional<String> getName() {
        if (this.name == null) {
            return Optional.empty();
        }
        return this.name;
    }

    @JsonIgnore
    public Optional<String> getAbbreviation() {
        if (this.abbreviation == null) {
            return Optional.empty();
        }
        return this.abbreviation;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="name")
    private Optional<String> _getName() {
        return this.name;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="abbreviation")
    private Optional<String> _getAbbreviation() {
        return this.abbreviation;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof StandardUnitDescription && this.equalTo((StandardUnitDescription)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(StandardUnitDescription other) {
        return this.unit.equals(other.unit) && this.name.equals(other.name) && this.abbreviation.equals(other.abbreviation);
    }

    public int hashCode() {
        return Objects.hash(this.unit, this.name, this.abbreviation);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<MeasurementUnit> unit = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> abbreviation = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(StandardUnitDescription other) {
            this.unit(other.getUnit());
            this.name(other.getName());
            this.abbreviation(other.getAbbreviation());
            return this;
        }

        @JsonSetter(value="unit", nulls=Nulls.SKIP)
        public Builder unit(Optional<MeasurementUnit> unit) {
            this.unit = unit;
            return this;
        }

        public Builder unit(MeasurementUnit unit) {
            this.unit = Optional.ofNullable(unit);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder name(Nullable<String> name) {
            this.name = name.isNull() ? null : (name.isEmpty() ? Optional.empty() : Optional.of(name.get()));
            return this;
        }

        @JsonSetter(value="abbreviation", nulls=Nulls.SKIP)
        public Builder abbreviation(Optional<String> abbreviation) {
            this.abbreviation = abbreviation;
            return this;
        }

        public Builder abbreviation(String abbreviation) {
            this.abbreviation = Optional.ofNullable(abbreviation);
            return this;
        }

        public Builder abbreviation(Nullable<String> abbreviation) {
            this.abbreviation = abbreviation.isNull() ? null : (abbreviation.isEmpty() ? Optional.empty() : Optional.of(abbreviation.get()));
            return this;
        }

        public StandardUnitDescription build() {
            return new StandardUnitDescription(this.unit, this.name, this.abbreviation, this.additionalProperties);
        }
    }
}

