/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SquareAccountDetails {
    private final Optional<String> paymentSourceToken;
    private final Optional<List<Error>> errors;
    private final Map<String, Object> additionalProperties;

    private SquareAccountDetails(Optional<String> paymentSourceToken, Optional<List<Error>> errors, Map<String, Object> additionalProperties) {
        this.paymentSourceToken = paymentSourceToken;
        this.errors = errors;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getPaymentSourceToken() {
        if (this.paymentSourceToken == null) {
            return Optional.empty();
        }
        return this.paymentSourceToken;
    }

    @JsonIgnore
    public Optional<List<Error>> getErrors() {
        if (this.errors == null) {
            return Optional.empty();
        }
        return this.errors;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="payment_source_token")
    private Optional<String> _getPaymentSourceToken() {
        return this.paymentSourceToken;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="errors")
    private Optional<List<Error>> _getErrors() {
        return this.errors;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SquareAccountDetails && this.equalTo((SquareAccountDetails)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SquareAccountDetails other) {
        return this.paymentSourceToken.equals(other.paymentSourceToken) && this.errors.equals(other.errors);
    }

    public int hashCode() {
        return Objects.hash(this.paymentSourceToken, this.errors);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> paymentSourceToken = Optional.empty();
        private Optional<List<Error>> errors = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SquareAccountDetails other) {
            this.paymentSourceToken(other.getPaymentSourceToken());
            this.errors(other.getErrors());
            return this;
        }

        @JsonSetter(value="payment_source_token", nulls=Nulls.SKIP)
        public Builder paymentSourceToken(Optional<String> paymentSourceToken) {
            this.paymentSourceToken = paymentSourceToken;
            return this;
        }

        public Builder paymentSourceToken(String paymentSourceToken) {
            this.paymentSourceToken = Optional.ofNullable(paymentSourceToken);
            return this;
        }

        public Builder paymentSourceToken(Nullable<String> paymentSourceToken) {
            this.paymentSourceToken = paymentSourceToken.isNull() ? null : (paymentSourceToken.isEmpty() ? Optional.empty() : Optional.of(paymentSourceToken.get()));
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        public Builder errors(Nullable<List<Error>> errors) {
            this.errors = errors.isNull() ? null : (errors.isEmpty() ? Optional.empty() : Optional.of(errors.get()));
            return this;
        }

        public SquareAccountDetails build() {
            return new SquareAccountDetails(this.paymentSourceToken, this.errors, this.additionalProperties);
        }
    }
}

