/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Product;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SourceApplication {
    private final Optional<Product> product;
    private final Optional<String> applicationId;
    private final Optional<String> name;
    private final Map<String, Object> additionalProperties;

    private SourceApplication(Optional<Product> product, Optional<String> applicationId, Optional<String> name, Map<String, Object> additionalProperties) {
        this.product = product;
        this.applicationId = applicationId;
        this.name = name;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="product")
    public Optional<Product> getProduct() {
        return this.product;
    }

    @JsonIgnore
    public Optional<String> getApplicationId() {
        if (this.applicationId == null) {
            return Optional.empty();
        }
        return this.applicationId;
    }

    @JsonIgnore
    public Optional<String> getName() {
        if (this.name == null) {
            return Optional.empty();
        }
        return this.name;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="application_id")
    private Optional<String> _getApplicationId() {
        return this.applicationId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="name")
    private Optional<String> _getName() {
        return this.name;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SourceApplication && this.equalTo((SourceApplication)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SourceApplication other) {
        return this.product.equals(other.product) && this.applicationId.equals(other.applicationId) && this.name.equals(other.name);
    }

    public int hashCode() {
        return Objects.hash(this.product, this.applicationId, this.name);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Product> product = Optional.empty();
        private Optional<String> applicationId = Optional.empty();
        private Optional<String> name = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SourceApplication other) {
            this.product(other.getProduct());
            this.applicationId(other.getApplicationId());
            this.name(other.getName());
            return this;
        }

        @JsonSetter(value="product", nulls=Nulls.SKIP)
        public Builder product(Optional<Product> product) {
            this.product = product;
            return this;
        }

        public Builder product(Product product) {
            this.product = Optional.ofNullable(product);
            return this;
        }

        @JsonSetter(value="application_id", nulls=Nulls.SKIP)
        public Builder applicationId(Optional<String> applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public Builder applicationId(String applicationId) {
            this.applicationId = Optional.ofNullable(applicationId);
            return this;
        }

        public Builder applicationId(Nullable<String> applicationId) {
            this.applicationId = applicationId.isNull() ? null : (applicationId.isEmpty() ? Optional.empty() : Optional.of(applicationId.get()));
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder name(Nullable<String> name) {
            this.name = name.isNull() ? null : (name.isEmpty() ? Optional.empty() : Optional.of(name.get()));
            return this;
        }

        public SourceApplication build() {
            return new SourceApplication(this.product, this.applicationId, this.name, this.additionalProperties);
        }
    }
}

