/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.SelectOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SelectOptions {
    private final String title;
    private final String body;
    private final List<SelectOption> options;
    private final Optional<SelectOption> selectedOption;
    private final Map<String, Object> additionalProperties;

    private SelectOptions(String title, String body, List<SelectOption> options, Optional<SelectOption> selectedOption, Map<String, Object> additionalProperties) {
        this.title = title;
        this.body = body;
        this.options = options;
        this.selectedOption = selectedOption;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="body")
    public String getBody() {
        return this.body;
    }

    @JsonProperty(value="options")
    public List<SelectOption> getOptions() {
        return this.options;
    }

    @JsonProperty(value="selected_option")
    public Optional<SelectOption> getSelectedOption() {
        return this.selectedOption;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SelectOptions && this.equalTo((SelectOptions)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SelectOptions other) {
        return this.title.equals(other.title) && this.body.equals(other.body) && this.options.equals(other.options) && this.selectedOption.equals(other.selectedOption);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.body, this.options, this.selectedOption);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TitleStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TitleStage,
    BodyStage,
    _FinalStage {
        private String title;
        private String body;
        private Optional<SelectOption> selectedOption = Optional.empty();
        private List<SelectOption> options = new ArrayList<SelectOption>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(SelectOptions other) {
            this.title(other.getTitle());
            this.body(other.getBody());
            this.options(other.getOptions());
            this.selectedOption(other.getSelectedOption());
            return this;
        }

        @Override
        @JsonSetter(value="title")
        public BodyStage title(@NotNull String title) {
            this.title = Objects.requireNonNull(title, "title must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="body")
        public _FinalStage body(@NotNull String body) {
            this.body = Objects.requireNonNull(body, "body must not be null");
            return this;
        }

        @Override
        public _FinalStage selectedOption(SelectOption selectedOption) {
            this.selectedOption = Optional.ofNullable(selectedOption);
            return this;
        }

        @Override
        @JsonSetter(value="selected_option", nulls=Nulls.SKIP)
        public _FinalStage selectedOption(Optional<SelectOption> selectedOption) {
            this.selectedOption = selectedOption;
            return this;
        }

        @Override
        public _FinalStage addAllOptions(List<SelectOption> options) {
            this.options.addAll(options);
            return this;
        }

        @Override
        public _FinalStage addOptions(SelectOption options) {
            this.options.add(options);
            return this;
        }

        @Override
        @JsonSetter(value="options", nulls=Nulls.SKIP)
        public _FinalStage options(List<SelectOption> options) {
            this.options.clear();
            this.options.addAll(options);
            return this;
        }

        @Override
        public SelectOptions build() {
            return new SelectOptions(this.title, this.body, this.options, this.selectedOption, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public SelectOptions build();

        public _FinalStage options(List<SelectOption> var1);

        public _FinalStage addOptions(SelectOption var1);

        public _FinalStage addAllOptions(List<SelectOption> var1);

        public _FinalStage selectedOption(Optional<SelectOption> var1);

        public _FinalStage selectedOption(SelectOption var1);
    }

    public static interface BodyStage {
        public _FinalStage body(@NotNull String var1);
    }

    public static interface TitleStage {
        public BodyStage title(@NotNull String var1);

        public Builder from(SelectOptions var1);
    }
}

