/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.Timecard;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SearchTimecardsResponse {
    private final Optional<List<Timecard>> timecards;
    private final Optional<String> cursor;
    private final Optional<List<Error>> errors;
    private final Map<String, Object> additionalProperties;

    private SearchTimecardsResponse(Optional<List<Timecard>> timecards, Optional<String> cursor, Optional<List<Error>> errors, Map<String, Object> additionalProperties) {
        this.timecards = timecards;
        this.cursor = cursor;
        this.errors = errors;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="timecards")
    public Optional<List<Timecard>> getTimecards() {
        return this.timecards;
    }

    @JsonProperty(value="cursor")
    public Optional<String> getCursor() {
        return this.cursor;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SearchTimecardsResponse && this.equalTo((SearchTimecardsResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchTimecardsResponse other) {
        return this.timecards.equals(other.timecards) && this.cursor.equals(other.cursor) && this.errors.equals(other.errors);
    }

    public int hashCode() {
        return Objects.hash(this.timecards, this.cursor, this.errors);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Timecard>> timecards = Optional.empty();
        private Optional<String> cursor = Optional.empty();
        private Optional<List<Error>> errors = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SearchTimecardsResponse other) {
            this.timecards(other.getTimecards());
            this.cursor(other.getCursor());
            this.errors(other.getErrors());
            return this;
        }

        @JsonSetter(value="timecards", nulls=Nulls.SKIP)
        public Builder timecards(Optional<List<Timecard>> timecards) {
            this.timecards = timecards;
            return this;
        }

        public Builder timecards(List<Timecard> timecards) {
            this.timecards = Optional.ofNullable(timecards);
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        public SearchTimecardsResponse build() {
            return new SearchTimecardsResponse(this.timecards, this.cursor, this.errors, this.additionalProperties);
        }
    }
}

