/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.SearchSubscriptionsQuery;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SearchSubscriptionsRequest {
    private final Optional<String> cursor;
    private final Optional<Integer> limit;
    private final Optional<SearchSubscriptionsQuery> query;
    private final Optional<List<String>> include;
    private final Map<String, Object> additionalProperties;

    private SearchSubscriptionsRequest(Optional<String> cursor, Optional<Integer> limit, Optional<SearchSubscriptionsQuery> query, Optional<List<String>> include, Map<String, Object> additionalProperties) {
        this.cursor = cursor;
        this.limit = limit;
        this.query = query;
        this.include = include;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="cursor")
    public Optional<String> getCursor() {
        return this.cursor;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    @JsonProperty(value="query")
    public Optional<SearchSubscriptionsQuery> getQuery() {
        return this.query;
    }

    @JsonProperty(value="include")
    public Optional<List<String>> getInclude() {
        return this.include;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SearchSubscriptionsRequest && this.equalTo((SearchSubscriptionsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchSubscriptionsRequest other) {
        return this.cursor.equals(other.cursor) && this.limit.equals(other.limit) && this.query.equals(other.query) && this.include.equals(other.include);
    }

    public int hashCode() {
        return Objects.hash(this.cursor, this.limit, this.query, this.include);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> cursor = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<SearchSubscriptionsQuery> query = Optional.empty();
        private Optional<List<String>> include = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SearchSubscriptionsRequest other) {
            this.cursor(other.getCursor());
            this.limit(other.getLimit());
            this.query(other.getQuery());
            this.include(other.getInclude());
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @JsonSetter(value="query", nulls=Nulls.SKIP)
        public Builder query(Optional<SearchSubscriptionsQuery> query) {
            this.query = query;
            return this;
        }

        public Builder query(SearchSubscriptionsQuery query) {
            this.query = Optional.ofNullable(query);
            return this;
        }

        @JsonSetter(value="include", nulls=Nulls.SKIP)
        public Builder include(Optional<List<String>> include) {
            this.include = include;
            return this;
        }

        public Builder include(List<String> include) {
            this.include = Optional.ofNullable(include);
            return this;
        }

        public SearchSubscriptionsRequest build() {
            return new SearchSubscriptionsRequest(this.cursor, this.limit, this.query, this.include, this.additionalProperties);
        }
    }
}

