/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.SearchOrdersQuery;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SearchOrdersRequest {
    private final Optional<List<String>> locationIds;
    private final Optional<String> cursor;
    private final Optional<SearchOrdersQuery> query;
    private final Optional<Integer> limit;
    private final Optional<Boolean> returnEntries;
    private final Map<String, Object> additionalProperties;

    private SearchOrdersRequest(Optional<List<String>> locationIds, Optional<String> cursor, Optional<SearchOrdersQuery> query, Optional<Integer> limit, Optional<Boolean> returnEntries, Map<String, Object> additionalProperties) {
        this.locationIds = locationIds;
        this.cursor = cursor;
        this.query = query;
        this.limit = limit;
        this.returnEntries = returnEntries;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="location_ids")
    public Optional<List<String>> getLocationIds() {
        return this.locationIds;
    }

    @JsonProperty(value="cursor")
    public Optional<String> getCursor() {
        return this.cursor;
    }

    @JsonProperty(value="query")
    public Optional<SearchOrdersQuery> getQuery() {
        return this.query;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    @JsonProperty(value="return_entries")
    public Optional<Boolean> getReturnEntries() {
        return this.returnEntries;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SearchOrdersRequest && this.equalTo((SearchOrdersRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchOrdersRequest other) {
        return this.locationIds.equals(other.locationIds) && this.cursor.equals(other.cursor) && this.query.equals(other.query) && this.limit.equals(other.limit) && this.returnEntries.equals(other.returnEntries);
    }

    public int hashCode() {
        return Objects.hash(this.locationIds, this.cursor, this.query, this.limit, this.returnEntries);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<String>> locationIds = Optional.empty();
        private Optional<String> cursor = Optional.empty();
        private Optional<SearchOrdersQuery> query = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<Boolean> returnEntries = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SearchOrdersRequest other) {
            this.locationIds(other.getLocationIds());
            this.cursor(other.getCursor());
            this.query(other.getQuery());
            this.limit(other.getLimit());
            this.returnEntries(other.getReturnEntries());
            return this;
        }

        @JsonSetter(value="location_ids", nulls=Nulls.SKIP)
        public Builder locationIds(Optional<List<String>> locationIds) {
            this.locationIds = locationIds;
            return this;
        }

        public Builder locationIds(List<String> locationIds) {
            this.locationIds = Optional.ofNullable(locationIds);
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        @JsonSetter(value="query", nulls=Nulls.SKIP)
        public Builder query(Optional<SearchOrdersQuery> query) {
            this.query = query;
            return this;
        }

        public Builder query(SearchOrdersQuery query) {
            this.query = Optional.ofNullable(query);
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @JsonSetter(value="return_entries", nulls=Nulls.SKIP)
        public Builder returnEntries(Optional<Boolean> returnEntries) {
            this.returnEntries = returnEntries;
            return this;
        }

        public Builder returnEntries(Boolean returnEntries) {
            this.returnEntries = Optional.ofNullable(returnEntries);
            return this;
        }

        public SearchOrdersRequest build() {
            return new SearchOrdersRequest(this.locationIds, this.cursor, this.query, this.limit, this.returnEntries, this.additionalProperties);
        }
    }
}

