/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.SearchOrdersCustomerFilter;
import com.squareup.square.types.SearchOrdersDateTimeFilter;
import com.squareup.square.types.SearchOrdersFulfillmentFilter;
import com.squareup.square.types.SearchOrdersSourceFilter;
import com.squareup.square.types.SearchOrdersStateFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SearchOrdersFilter {
    private final Optional<SearchOrdersStateFilter> stateFilter;
    private final Optional<SearchOrdersDateTimeFilter> dateTimeFilter;
    private final Optional<SearchOrdersFulfillmentFilter> fulfillmentFilter;
    private final Optional<SearchOrdersSourceFilter> sourceFilter;
    private final Optional<SearchOrdersCustomerFilter> customerFilter;
    private final Map<String, Object> additionalProperties;

    private SearchOrdersFilter(Optional<SearchOrdersStateFilter> stateFilter, Optional<SearchOrdersDateTimeFilter> dateTimeFilter, Optional<SearchOrdersFulfillmentFilter> fulfillmentFilter, Optional<SearchOrdersSourceFilter> sourceFilter, Optional<SearchOrdersCustomerFilter> customerFilter, Map<String, Object> additionalProperties) {
        this.stateFilter = stateFilter;
        this.dateTimeFilter = dateTimeFilter;
        this.fulfillmentFilter = fulfillmentFilter;
        this.sourceFilter = sourceFilter;
        this.customerFilter = customerFilter;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="state_filter")
    public Optional<SearchOrdersStateFilter> getStateFilter() {
        return this.stateFilter;
    }

    @JsonProperty(value="date_time_filter")
    public Optional<SearchOrdersDateTimeFilter> getDateTimeFilter() {
        return this.dateTimeFilter;
    }

    @JsonProperty(value="fulfillment_filter")
    public Optional<SearchOrdersFulfillmentFilter> getFulfillmentFilter() {
        return this.fulfillmentFilter;
    }

    @JsonProperty(value="source_filter")
    public Optional<SearchOrdersSourceFilter> getSourceFilter() {
        return this.sourceFilter;
    }

    @JsonProperty(value="customer_filter")
    public Optional<SearchOrdersCustomerFilter> getCustomerFilter() {
        return this.customerFilter;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SearchOrdersFilter && this.equalTo((SearchOrdersFilter)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchOrdersFilter other) {
        return this.stateFilter.equals(other.stateFilter) && this.dateTimeFilter.equals(other.dateTimeFilter) && this.fulfillmentFilter.equals(other.fulfillmentFilter) && this.sourceFilter.equals(other.sourceFilter) && this.customerFilter.equals(other.customerFilter);
    }

    public int hashCode() {
        return Objects.hash(this.stateFilter, this.dateTimeFilter, this.fulfillmentFilter, this.sourceFilter, this.customerFilter);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<SearchOrdersStateFilter> stateFilter = Optional.empty();
        private Optional<SearchOrdersDateTimeFilter> dateTimeFilter = Optional.empty();
        private Optional<SearchOrdersFulfillmentFilter> fulfillmentFilter = Optional.empty();
        private Optional<SearchOrdersSourceFilter> sourceFilter = Optional.empty();
        private Optional<SearchOrdersCustomerFilter> customerFilter = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SearchOrdersFilter other) {
            this.stateFilter(other.getStateFilter());
            this.dateTimeFilter(other.getDateTimeFilter());
            this.fulfillmentFilter(other.getFulfillmentFilter());
            this.sourceFilter(other.getSourceFilter());
            this.customerFilter(other.getCustomerFilter());
            return this;
        }

        @JsonSetter(value="state_filter", nulls=Nulls.SKIP)
        public Builder stateFilter(Optional<SearchOrdersStateFilter> stateFilter) {
            this.stateFilter = stateFilter;
            return this;
        }

        public Builder stateFilter(SearchOrdersStateFilter stateFilter) {
            this.stateFilter = Optional.ofNullable(stateFilter);
            return this;
        }

        @JsonSetter(value="date_time_filter", nulls=Nulls.SKIP)
        public Builder dateTimeFilter(Optional<SearchOrdersDateTimeFilter> dateTimeFilter) {
            this.dateTimeFilter = dateTimeFilter;
            return this;
        }

        public Builder dateTimeFilter(SearchOrdersDateTimeFilter dateTimeFilter) {
            this.dateTimeFilter = Optional.ofNullable(dateTimeFilter);
            return this;
        }

        @JsonSetter(value="fulfillment_filter", nulls=Nulls.SKIP)
        public Builder fulfillmentFilter(Optional<SearchOrdersFulfillmentFilter> fulfillmentFilter) {
            this.fulfillmentFilter = fulfillmentFilter;
            return this;
        }

        public Builder fulfillmentFilter(SearchOrdersFulfillmentFilter fulfillmentFilter) {
            this.fulfillmentFilter = Optional.ofNullable(fulfillmentFilter);
            return this;
        }

        @JsonSetter(value="source_filter", nulls=Nulls.SKIP)
        public Builder sourceFilter(Optional<SearchOrdersSourceFilter> sourceFilter) {
            this.sourceFilter = sourceFilter;
            return this;
        }

        public Builder sourceFilter(SearchOrdersSourceFilter sourceFilter) {
            this.sourceFilter = Optional.ofNullable(sourceFilter);
            return this;
        }

        @JsonSetter(value="customer_filter", nulls=Nulls.SKIP)
        public Builder customerFilter(Optional<SearchOrdersCustomerFilter> customerFilter) {
            this.customerFilter = customerFilter;
            return this;
        }

        public Builder customerFilter(SearchOrdersCustomerFilter customerFilter) {
            this.customerFilter = Optional.ofNullable(customerFilter);
            return this;
        }

        public SearchOrdersFilter build() {
            return new SearchOrdersFilter(this.stateFilter, this.dateTimeFilter, this.fulfillmentFilter, this.sourceFilter, this.customerFilter, this.additionalProperties);
        }
    }
}

