/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.LoyaltyReward;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SearchLoyaltyRewardsResponse {
    private final Optional<List<Error>> errors;
    private final Optional<List<LoyaltyReward>> rewards;
    private final Optional<String> cursor;
    private final Map<String, Object> additionalProperties;

    private SearchLoyaltyRewardsResponse(Optional<List<Error>> errors, Optional<List<LoyaltyReward>> rewards, Optional<String> cursor, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.rewards = rewards;
        this.cursor = cursor;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="rewards")
    public Optional<List<LoyaltyReward>> getRewards() {
        return this.rewards;
    }

    @JsonProperty(value="cursor")
    public Optional<String> getCursor() {
        return this.cursor;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SearchLoyaltyRewardsResponse && this.equalTo((SearchLoyaltyRewardsResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchLoyaltyRewardsResponse other) {
        return this.errors.equals(other.errors) && this.rewards.equals(other.rewards) && this.cursor.equals(other.cursor);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.rewards, this.cursor);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<List<LoyaltyReward>> rewards = Optional.empty();
        private Optional<String> cursor = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SearchLoyaltyRewardsResponse other) {
            this.errors(other.getErrors());
            this.rewards(other.getRewards());
            this.cursor(other.getCursor());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="rewards", nulls=Nulls.SKIP)
        public Builder rewards(Optional<List<LoyaltyReward>> rewards) {
            this.rewards = rewards;
            return this;
        }

        public Builder rewards(List<LoyaltyReward> rewards) {
            this.rewards = Optional.ofNullable(rewards);
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        public SearchLoyaltyRewardsResponse build() {
            return new SearchLoyaltyRewardsResponse(this.errors, this.rewards, this.cursor, this.additionalProperties);
        }
    }
}

