/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CustomerQuery;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SearchCustomersRequest {
    private final Optional<String> cursor;
    private final Optional<Long> limit;
    private final Optional<CustomerQuery> query;
    private final Optional<Boolean> count;
    private final Map<String, Object> additionalProperties;

    private SearchCustomersRequest(Optional<String> cursor, Optional<Long> limit, Optional<CustomerQuery> query, Optional<Boolean> count, Map<String, Object> additionalProperties) {
        this.cursor = cursor;
        this.limit = limit;
        this.query = query;
        this.count = count;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="cursor")
    public Optional<String> getCursor() {
        return this.cursor;
    }

    @JsonProperty(value="limit")
    public Optional<Long> getLimit() {
        return this.limit;
    }

    @JsonProperty(value="query")
    public Optional<CustomerQuery> getQuery() {
        return this.query;
    }

    @JsonProperty(value="count")
    public Optional<Boolean> getCount() {
        return this.count;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SearchCustomersRequest && this.equalTo((SearchCustomersRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchCustomersRequest other) {
        return this.cursor.equals(other.cursor) && this.limit.equals(other.limit) && this.query.equals(other.query) && this.count.equals(other.count);
    }

    public int hashCode() {
        return Objects.hash(this.cursor, this.limit, this.query, this.count);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> cursor = Optional.empty();
        private Optional<Long> limit = Optional.empty();
        private Optional<CustomerQuery> query = Optional.empty();
        private Optional<Boolean> count = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SearchCustomersRequest other) {
            this.cursor(other.getCursor());
            this.limit(other.getLimit());
            this.query(other.getQuery());
            this.count(other.getCount());
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Long> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Long limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @JsonSetter(value="query", nulls=Nulls.SKIP)
        public Builder query(Optional<CustomerQuery> query) {
            this.query = query;
            return this;
        }

        public Builder query(CustomerQuery query) {
            this.query = Optional.ofNullable(query);
            return this;
        }

        @JsonSetter(value="count", nulls=Nulls.SKIP)
        public Builder count(Optional<Boolean> count) {
            this.count = count;
            return this;
        }

        public Builder count(Boolean count) {
            this.count = Optional.ofNullable(count);
            return this;
        }

        public SearchCustomersRequest build() {
            return new SearchCustomersRequest(this.cursor, this.limit, this.query, this.count, this.additionalProperties);
        }
    }
}

