/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CatalogObjectType;
import com.squareup.square.types.CatalogQuery;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SearchCatalogObjectsRequest {
    private final Optional<String> cursor;
    private final Optional<List<CatalogObjectType>> objectTypes;
    private final Optional<Boolean> includeDeletedObjects;
    private final Optional<Boolean> includeRelatedObjects;
    private final Optional<String> beginTime;
    private final Optional<CatalogQuery> query;
    private final Optional<Integer> limit;
    private final Optional<Boolean> includeCategoryPathToRoot;
    private final Map<String, Object> additionalProperties;

    private SearchCatalogObjectsRequest(Optional<String> cursor, Optional<List<CatalogObjectType>> objectTypes, Optional<Boolean> includeDeletedObjects, Optional<Boolean> includeRelatedObjects, Optional<String> beginTime, Optional<CatalogQuery> query, Optional<Integer> limit, Optional<Boolean> includeCategoryPathToRoot, Map<String, Object> additionalProperties) {
        this.cursor = cursor;
        this.objectTypes = objectTypes;
        this.includeDeletedObjects = includeDeletedObjects;
        this.includeRelatedObjects = includeRelatedObjects;
        this.beginTime = beginTime;
        this.query = query;
        this.limit = limit;
        this.includeCategoryPathToRoot = includeCategoryPathToRoot;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="cursor")
    public Optional<String> getCursor() {
        return this.cursor;
    }

    @JsonProperty(value="object_types")
    public Optional<List<CatalogObjectType>> getObjectTypes() {
        return this.objectTypes;
    }

    @JsonProperty(value="include_deleted_objects")
    public Optional<Boolean> getIncludeDeletedObjects() {
        return this.includeDeletedObjects;
    }

    @JsonProperty(value="include_related_objects")
    public Optional<Boolean> getIncludeRelatedObjects() {
        return this.includeRelatedObjects;
    }

    @JsonProperty(value="begin_time")
    public Optional<String> getBeginTime() {
        return this.beginTime;
    }

    @JsonProperty(value="query")
    public Optional<CatalogQuery> getQuery() {
        return this.query;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    @JsonProperty(value="include_category_path_to_root")
    public Optional<Boolean> getIncludeCategoryPathToRoot() {
        return this.includeCategoryPathToRoot;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SearchCatalogObjectsRequest && this.equalTo((SearchCatalogObjectsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchCatalogObjectsRequest other) {
        return this.cursor.equals(other.cursor) && this.objectTypes.equals(other.objectTypes) && this.includeDeletedObjects.equals(other.includeDeletedObjects) && this.includeRelatedObjects.equals(other.includeRelatedObjects) && this.beginTime.equals(other.beginTime) && this.query.equals(other.query) && this.limit.equals(other.limit) && this.includeCategoryPathToRoot.equals(other.includeCategoryPathToRoot);
    }

    public int hashCode() {
        return Objects.hash(this.cursor, this.objectTypes, this.includeDeletedObjects, this.includeRelatedObjects, this.beginTime, this.query, this.limit, this.includeCategoryPathToRoot);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> cursor = Optional.empty();
        private Optional<List<CatalogObjectType>> objectTypes = Optional.empty();
        private Optional<Boolean> includeDeletedObjects = Optional.empty();
        private Optional<Boolean> includeRelatedObjects = Optional.empty();
        private Optional<String> beginTime = Optional.empty();
        private Optional<CatalogQuery> query = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<Boolean> includeCategoryPathToRoot = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SearchCatalogObjectsRequest other) {
            this.cursor(other.getCursor());
            this.objectTypes(other.getObjectTypes());
            this.includeDeletedObjects(other.getIncludeDeletedObjects());
            this.includeRelatedObjects(other.getIncludeRelatedObjects());
            this.beginTime(other.getBeginTime());
            this.query(other.getQuery());
            this.limit(other.getLimit());
            this.includeCategoryPathToRoot(other.getIncludeCategoryPathToRoot());
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        @JsonSetter(value="object_types", nulls=Nulls.SKIP)
        public Builder objectTypes(Optional<List<CatalogObjectType>> objectTypes) {
            this.objectTypes = objectTypes;
            return this;
        }

        public Builder objectTypes(List<CatalogObjectType> objectTypes) {
            this.objectTypes = Optional.ofNullable(objectTypes);
            return this;
        }

        @JsonSetter(value="include_deleted_objects", nulls=Nulls.SKIP)
        public Builder includeDeletedObjects(Optional<Boolean> includeDeletedObjects) {
            this.includeDeletedObjects = includeDeletedObjects;
            return this;
        }

        public Builder includeDeletedObjects(Boolean includeDeletedObjects) {
            this.includeDeletedObjects = Optional.ofNullable(includeDeletedObjects);
            return this;
        }

        @JsonSetter(value="include_related_objects", nulls=Nulls.SKIP)
        public Builder includeRelatedObjects(Optional<Boolean> includeRelatedObjects) {
            this.includeRelatedObjects = includeRelatedObjects;
            return this;
        }

        public Builder includeRelatedObjects(Boolean includeRelatedObjects) {
            this.includeRelatedObjects = Optional.ofNullable(includeRelatedObjects);
            return this;
        }

        @JsonSetter(value="begin_time", nulls=Nulls.SKIP)
        public Builder beginTime(Optional<String> beginTime) {
            this.beginTime = beginTime;
            return this;
        }

        public Builder beginTime(String beginTime) {
            this.beginTime = Optional.ofNullable(beginTime);
            return this;
        }

        @JsonSetter(value="query", nulls=Nulls.SKIP)
        public Builder query(Optional<CatalogQuery> query) {
            this.query = query;
            return this;
        }

        public Builder query(CatalogQuery query) {
            this.query = Optional.ofNullable(query);
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @JsonSetter(value="include_category_path_to_root", nulls=Nulls.SKIP)
        public Builder includeCategoryPathToRoot(Optional<Boolean> includeCategoryPathToRoot) {
            this.includeCategoryPathToRoot = includeCategoryPathToRoot;
            return this;
        }

        public Builder includeCategoryPathToRoot(Boolean includeCategoryPathToRoot) {
            this.includeCategoryPathToRoot = Optional.ofNullable(includeCategoryPathToRoot);
            return this;
        }

        public SearchCatalogObjectsRequest build() {
            return new SearchCatalogObjectsRequest(this.cursor, this.objectTypes, this.includeDeletedObjects, this.includeRelatedObjects, this.beginTime, this.query, this.limit, this.includeCategoryPathToRoot, this.additionalProperties);
        }
    }
}

