/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.ArchivedState;
import com.squareup.square.types.CatalogItemProductType;
import com.squareup.square.types.CustomAttributeFilter;
import com.squareup.square.types.SearchCatalogItemsRequestStockLevel;
import com.squareup.square.types.SortOrder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SearchCatalogItemsRequest {
    private final Optional<String> textFilter;
    private final Optional<List<String>> categoryIds;
    private final Optional<List<SearchCatalogItemsRequestStockLevel>> stockLevels;
    private final Optional<List<String>> enabledLocationIds;
    private final Optional<String> cursor;
    private final Optional<Integer> limit;
    private final Optional<SortOrder> sortOrder;
    private final Optional<List<CatalogItemProductType>> productTypes;
    private final Optional<List<CustomAttributeFilter>> customAttributeFilters;
    private final Optional<ArchivedState> archivedState;
    private final Map<String, Object> additionalProperties;

    private SearchCatalogItemsRequest(Optional<String> textFilter, Optional<List<String>> categoryIds, Optional<List<SearchCatalogItemsRequestStockLevel>> stockLevels, Optional<List<String>> enabledLocationIds, Optional<String> cursor, Optional<Integer> limit, Optional<SortOrder> sortOrder, Optional<List<CatalogItemProductType>> productTypes, Optional<List<CustomAttributeFilter>> customAttributeFilters, Optional<ArchivedState> archivedState, Map<String, Object> additionalProperties) {
        this.textFilter = textFilter;
        this.categoryIds = categoryIds;
        this.stockLevels = stockLevels;
        this.enabledLocationIds = enabledLocationIds;
        this.cursor = cursor;
        this.limit = limit;
        this.sortOrder = sortOrder;
        this.productTypes = productTypes;
        this.customAttributeFilters = customAttributeFilters;
        this.archivedState = archivedState;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="text_filter")
    public Optional<String> getTextFilter() {
        return this.textFilter;
    }

    @JsonProperty(value="category_ids")
    public Optional<List<String>> getCategoryIds() {
        return this.categoryIds;
    }

    @JsonProperty(value="stock_levels")
    public Optional<List<SearchCatalogItemsRequestStockLevel>> getStockLevels() {
        return this.stockLevels;
    }

    @JsonProperty(value="enabled_location_ids")
    public Optional<List<String>> getEnabledLocationIds() {
        return this.enabledLocationIds;
    }

    @JsonProperty(value="cursor")
    public Optional<String> getCursor() {
        return this.cursor;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    @JsonProperty(value="sort_order")
    public Optional<SortOrder> getSortOrder() {
        return this.sortOrder;
    }

    @JsonProperty(value="product_types")
    public Optional<List<CatalogItemProductType>> getProductTypes() {
        return this.productTypes;
    }

    @JsonProperty(value="custom_attribute_filters")
    public Optional<List<CustomAttributeFilter>> getCustomAttributeFilters() {
        return this.customAttributeFilters;
    }

    @JsonProperty(value="archived_state")
    public Optional<ArchivedState> getArchivedState() {
        return this.archivedState;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SearchCatalogItemsRequest && this.equalTo((SearchCatalogItemsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchCatalogItemsRequest other) {
        return this.textFilter.equals(other.textFilter) && this.categoryIds.equals(other.categoryIds) && this.stockLevels.equals(other.stockLevels) && this.enabledLocationIds.equals(other.enabledLocationIds) && this.cursor.equals(other.cursor) && this.limit.equals(other.limit) && this.sortOrder.equals(other.sortOrder) && this.productTypes.equals(other.productTypes) && this.customAttributeFilters.equals(other.customAttributeFilters) && this.archivedState.equals(other.archivedState);
    }

    public int hashCode() {
        return Objects.hash(this.textFilter, this.categoryIds, this.stockLevels, this.enabledLocationIds, this.cursor, this.limit, this.sortOrder, this.productTypes, this.customAttributeFilters, this.archivedState);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> textFilter = Optional.empty();
        private Optional<List<String>> categoryIds = Optional.empty();
        private Optional<List<SearchCatalogItemsRequestStockLevel>> stockLevels = Optional.empty();
        private Optional<List<String>> enabledLocationIds = Optional.empty();
        private Optional<String> cursor = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<SortOrder> sortOrder = Optional.empty();
        private Optional<List<CatalogItemProductType>> productTypes = Optional.empty();
        private Optional<List<CustomAttributeFilter>> customAttributeFilters = Optional.empty();
        private Optional<ArchivedState> archivedState = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SearchCatalogItemsRequest other) {
            this.textFilter(other.getTextFilter());
            this.categoryIds(other.getCategoryIds());
            this.stockLevels(other.getStockLevels());
            this.enabledLocationIds(other.getEnabledLocationIds());
            this.cursor(other.getCursor());
            this.limit(other.getLimit());
            this.sortOrder(other.getSortOrder());
            this.productTypes(other.getProductTypes());
            this.customAttributeFilters(other.getCustomAttributeFilters());
            this.archivedState(other.getArchivedState());
            return this;
        }

        @JsonSetter(value="text_filter", nulls=Nulls.SKIP)
        public Builder textFilter(Optional<String> textFilter) {
            this.textFilter = textFilter;
            return this;
        }

        public Builder textFilter(String textFilter) {
            this.textFilter = Optional.ofNullable(textFilter);
            return this;
        }

        @JsonSetter(value="category_ids", nulls=Nulls.SKIP)
        public Builder categoryIds(Optional<List<String>> categoryIds) {
            this.categoryIds = categoryIds;
            return this;
        }

        public Builder categoryIds(List<String> categoryIds) {
            this.categoryIds = Optional.ofNullable(categoryIds);
            return this;
        }

        @JsonSetter(value="stock_levels", nulls=Nulls.SKIP)
        public Builder stockLevels(Optional<List<SearchCatalogItemsRequestStockLevel>> stockLevels) {
            this.stockLevels = stockLevels;
            return this;
        }

        public Builder stockLevels(List<SearchCatalogItemsRequestStockLevel> stockLevels) {
            this.stockLevels = Optional.ofNullable(stockLevels);
            return this;
        }

        @JsonSetter(value="enabled_location_ids", nulls=Nulls.SKIP)
        public Builder enabledLocationIds(Optional<List<String>> enabledLocationIds) {
            this.enabledLocationIds = enabledLocationIds;
            return this;
        }

        public Builder enabledLocationIds(List<String> enabledLocationIds) {
            this.enabledLocationIds = Optional.ofNullable(enabledLocationIds);
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @JsonSetter(value="sort_order", nulls=Nulls.SKIP)
        public Builder sortOrder(Optional<SortOrder> sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = Optional.ofNullable(sortOrder);
            return this;
        }

        @JsonSetter(value="product_types", nulls=Nulls.SKIP)
        public Builder productTypes(Optional<List<CatalogItemProductType>> productTypes) {
            this.productTypes = productTypes;
            return this;
        }

        public Builder productTypes(List<CatalogItemProductType> productTypes) {
            this.productTypes = Optional.ofNullable(productTypes);
            return this;
        }

        @JsonSetter(value="custom_attribute_filters", nulls=Nulls.SKIP)
        public Builder customAttributeFilters(Optional<List<CustomAttributeFilter>> customAttributeFilters) {
            this.customAttributeFilters = customAttributeFilters;
            return this;
        }

        public Builder customAttributeFilters(List<CustomAttributeFilter> customAttributeFilters) {
            this.customAttributeFilters = Optional.ofNullable(customAttributeFilters);
            return this;
        }

        @JsonSetter(value="archived_state", nulls=Nulls.SKIP)
        public Builder archivedState(Optional<ArchivedState> archivedState) {
            this.archivedState = archivedState;
            return this;
        }

        public Builder archivedState(ArchivedState archivedState) {
            this.archivedState = Optional.ofNullable(archivedState);
            return this;
        }

        public SearchCatalogItemsRequest build() {
            return new SearchCatalogItemsRequest(this.textFilter, this.categoryIds, this.stockLevels, this.enabledLocationIds, this.cursor, this.limit, this.sortOrder, this.productTypes, this.customAttributeFilters, this.archivedState, this.additionalProperties);
        }
    }
}

