/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.SearchAvailabilityQuery;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SearchAvailabilityRequest {
    private final SearchAvailabilityQuery query;
    private final Map<String, Object> additionalProperties;

    private SearchAvailabilityRequest(SearchAvailabilityQuery query, Map<String, Object> additionalProperties) {
        this.query = query;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="query")
    public SearchAvailabilityQuery getQuery() {
        return this.query;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SearchAvailabilityRequest && this.equalTo((SearchAvailabilityRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchAvailabilityRequest other) {
        return this.query.equals(other.query);
    }

    public int hashCode() {
        return Objects.hash(this.query);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static QueryStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements QueryStage,
    _FinalStage {
        private SearchAvailabilityQuery query;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(SearchAvailabilityRequest other) {
            this.query(other.getQuery());
            return this;
        }

        @Override
        @JsonSetter(value="query")
        public _FinalStage query(@NotNull SearchAvailabilityQuery query) {
            this.query = Objects.requireNonNull(query, "query must not be null");
            return this;
        }

        @Override
        public SearchAvailabilityRequest build() {
            return new SearchAvailabilityRequest(this.query, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public SearchAvailabilityRequest build();
    }

    public static interface QueryStage {
        public _FinalStage query(@NotNull SearchAvailabilityQuery var1);

        public Builder from(SearchAvailabilityRequest var1);
    }
}

