/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SaveCardOptions {
    private final String customerId;
    private final Optional<String> cardId;
    private final Optional<String> referenceId;
    private final Map<String, Object> additionalProperties;

    private SaveCardOptions(String customerId, Optional<String> cardId, Optional<String> referenceId, Map<String, Object> additionalProperties) {
        this.customerId = customerId;
        this.cardId = cardId;
        this.referenceId = referenceId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="customer_id")
    public String getCustomerId() {
        return this.customerId;
    }

    @JsonProperty(value="card_id")
    public Optional<String> getCardId() {
        return this.cardId;
    }

    @JsonIgnore
    public Optional<String> getReferenceId() {
        if (this.referenceId == null) {
            return Optional.empty();
        }
        return this.referenceId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="reference_id")
    private Optional<String> _getReferenceId() {
        return this.referenceId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SaveCardOptions && this.equalTo((SaveCardOptions)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SaveCardOptions other) {
        return this.customerId.equals(other.customerId) && this.cardId.equals(other.cardId) && this.referenceId.equals(other.referenceId);
    }

    public int hashCode() {
        return Objects.hash(this.customerId, this.cardId, this.referenceId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CustomerIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CustomerIdStage,
    _FinalStage {
        private String customerId;
        private Optional<String> referenceId = Optional.empty();
        private Optional<String> cardId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(SaveCardOptions other) {
            this.customerId(other.getCustomerId());
            this.cardId(other.getCardId());
            this.referenceId(other.getReferenceId());
            return this;
        }

        @Override
        @JsonSetter(value="customer_id")
        public _FinalStage customerId(@NotNull String customerId) {
            this.customerId = Objects.requireNonNull(customerId, "customerId must not be null");
            return this;
        }

        @Override
        public _FinalStage referenceId(Nullable<String> referenceId) {
            this.referenceId = referenceId.isNull() ? null : (referenceId.isEmpty() ? Optional.empty() : Optional.of(referenceId.get()));
            return this;
        }

        @Override
        public _FinalStage referenceId(String referenceId) {
            this.referenceId = Optional.ofNullable(referenceId);
            return this;
        }

        @Override
        @JsonSetter(value="reference_id", nulls=Nulls.SKIP)
        public _FinalStage referenceId(Optional<String> referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        @Override
        public _FinalStage cardId(String cardId) {
            this.cardId = Optional.ofNullable(cardId);
            return this;
        }

        @Override
        @JsonSetter(value="card_id", nulls=Nulls.SKIP)
        public _FinalStage cardId(Optional<String> cardId) {
            this.cardId = cardId;
            return this;
        }

        @Override
        public SaveCardOptions build() {
            return new SaveCardOptions(this.customerId, this.cardId, this.referenceId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public SaveCardOptions build();

        public _FinalStage cardId(Optional<String> var1);

        public _FinalStage cardId(String var1);

        public _FinalStage referenceId(Optional<String> var1);

        public _FinalStage referenceId(String var1);

        public _FinalStage referenceId(Nullable<String> var1);
    }

    public static interface CustomerIdStage {
        public _FinalStage customerId(@NotNull String var1);

        public Builder from(SaveCardOptions var1);
    }
}

