/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.Timecard;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class RetrieveTimecardResponse {
    private final Optional<Timecard> timecard;
    private final Optional<List<Error>> errors;
    private final Map<String, Object> additionalProperties;

    private RetrieveTimecardResponse(Optional<Timecard> timecard, Optional<List<Error>> errors, Map<String, Object> additionalProperties) {
        this.timecard = timecard;
        this.errors = errors;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="timecard")
    public Optional<Timecard> getTimecard() {
        return this.timecard;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof RetrieveTimecardResponse && this.equalTo((RetrieveTimecardResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RetrieveTimecardResponse other) {
        return this.timecard.equals(other.timecard) && this.errors.equals(other.errors);
    }

    public int hashCode() {
        return Objects.hash(this.timecard, this.errors);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Timecard> timecard = Optional.empty();
        private Optional<List<Error>> errors = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(RetrieveTimecardResponse other) {
            this.timecard(other.getTimecard());
            this.errors(other.getErrors());
            return this;
        }

        @JsonSetter(value="timecard", nulls=Nulls.SKIP)
        public Builder timecard(Optional<Timecard> timecard) {
            this.timecard = timecard;
            return this;
        }

        public Builder timecard(Timecard timecard) {
            this.timecard = Optional.ofNullable(timecard);
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        public RetrieveTimecardResponse build() {
            return new RetrieveTimecardResponse(this.timecard, this.errors, this.additionalProperties);
        }
    }
}

