/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.ChangeTiming;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ResumeSubscriptionRequest {
    private final String subscriptionId;
    private final Optional<String> resumeEffectiveDate;
    private final Optional<ChangeTiming> resumeChangeTiming;
    private final Map<String, Object> additionalProperties;

    private ResumeSubscriptionRequest(String subscriptionId, Optional<String> resumeEffectiveDate, Optional<ChangeTiming> resumeChangeTiming, Map<String, Object> additionalProperties) {
        this.subscriptionId = subscriptionId;
        this.resumeEffectiveDate = resumeEffectiveDate;
        this.resumeChangeTiming = resumeChangeTiming;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="subscription_id")
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @JsonIgnore
    public Optional<String> getResumeEffectiveDate() {
        if (this.resumeEffectiveDate == null) {
            return Optional.empty();
        }
        return this.resumeEffectiveDate;
    }

    @JsonProperty(value="resume_change_timing")
    public Optional<ChangeTiming> getResumeChangeTiming() {
        return this.resumeChangeTiming;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="resume_effective_date")
    private Optional<String> _getResumeEffectiveDate() {
        return this.resumeEffectiveDate;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ResumeSubscriptionRequest && this.equalTo((ResumeSubscriptionRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ResumeSubscriptionRequest other) {
        return this.subscriptionId.equals(other.subscriptionId) && this.resumeEffectiveDate.equals(other.resumeEffectiveDate) && this.resumeChangeTiming.equals(other.resumeChangeTiming);
    }

    public int hashCode() {
        return Objects.hash(this.subscriptionId, this.resumeEffectiveDate, this.resumeChangeTiming);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SubscriptionIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SubscriptionIdStage,
    _FinalStage {
        private String subscriptionId;
        private Optional<ChangeTiming> resumeChangeTiming = Optional.empty();
        private Optional<String> resumeEffectiveDate = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ResumeSubscriptionRequest other) {
            this.subscriptionId(other.getSubscriptionId());
            this.resumeEffectiveDate(other.getResumeEffectiveDate());
            this.resumeChangeTiming(other.getResumeChangeTiming());
            return this;
        }

        @Override
        @JsonSetter(value="subscription_id")
        public _FinalStage subscriptionId(@NotNull String subscriptionId) {
            this.subscriptionId = Objects.requireNonNull(subscriptionId, "subscriptionId must not be null");
            return this;
        }

        @Override
        public _FinalStage resumeChangeTiming(ChangeTiming resumeChangeTiming) {
            this.resumeChangeTiming = Optional.ofNullable(resumeChangeTiming);
            return this;
        }

        @Override
        @JsonSetter(value="resume_change_timing", nulls=Nulls.SKIP)
        public _FinalStage resumeChangeTiming(Optional<ChangeTiming> resumeChangeTiming) {
            this.resumeChangeTiming = resumeChangeTiming;
            return this;
        }

        @Override
        public _FinalStage resumeEffectiveDate(Nullable<String> resumeEffectiveDate) {
            this.resumeEffectiveDate = resumeEffectiveDate.isNull() ? null : (resumeEffectiveDate.isEmpty() ? Optional.empty() : Optional.of(resumeEffectiveDate.get()));
            return this;
        }

        @Override
        public _FinalStage resumeEffectiveDate(String resumeEffectiveDate) {
            this.resumeEffectiveDate = Optional.ofNullable(resumeEffectiveDate);
            return this;
        }

        @Override
        @JsonSetter(value="resume_effective_date", nulls=Nulls.SKIP)
        public _FinalStage resumeEffectiveDate(Optional<String> resumeEffectiveDate) {
            this.resumeEffectiveDate = resumeEffectiveDate;
            return this;
        }

        @Override
        public ResumeSubscriptionRequest build() {
            return new ResumeSubscriptionRequest(this.subscriptionId, this.resumeEffectiveDate, this.resumeChangeTiming, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ResumeSubscriptionRequest build();

        public _FinalStage resumeEffectiveDate(Optional<String> var1);

        public _FinalStage resumeEffectiveDate(String var1);

        public _FinalStage resumeEffectiveDate(Nullable<String> var1);

        public _FinalStage resumeChangeTiming(Optional<ChangeTiming> var1);

        public _FinalStage resumeChangeTiming(ChangeTiming var1);
    }

    public static interface SubscriptionIdStage {
        public _FinalStage subscriptionId(@NotNull String var1);

        public Builder from(ResumeSubscriptionRequest var1);
    }
}

