/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.RegisterDomainResponseStatus;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class RegisterDomainResponse {
    private final Optional<List<Error>> errors;
    private final Optional<RegisterDomainResponseStatus> status;
    private final Map<String, Object> additionalProperties;

    private RegisterDomainResponse(Optional<List<Error>> errors, Optional<RegisterDomainResponseStatus> status, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.status = status;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="status")
    public Optional<RegisterDomainResponseStatus> getStatus() {
        return this.status;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof RegisterDomainResponse && this.equalTo((RegisterDomainResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RegisterDomainResponse other) {
        return this.errors.equals(other.errors) && this.status.equals(other.status);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.status);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<RegisterDomainResponseStatus> status = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(RegisterDomainResponse other) {
            this.errors(other.getErrors());
            this.status(other.getStatus());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<RegisterDomainResponseStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(RegisterDomainResponseStatus status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        public RegisterDomainResponse build() {
            return new RegisterDomainResponse(this.errors, this.status, this.additionalProperties);
        }
    }
}

