/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class RefundStatus {
    public static final RefundStatus REJECTED = new RefundStatus(Value.REJECTED, "REJECTED");
    public static final RefundStatus APPROVED = new RefundStatus(Value.APPROVED, "APPROVED");
    public static final RefundStatus PENDING = new RefundStatus(Value.PENDING, "PENDING");
    public static final RefundStatus FAILED = new RefundStatus(Value.FAILED, "FAILED");
    private final Value value;
    private final String string;

    RefundStatus(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof RefundStatus && this.string.equals(((RefundStatus)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case REJECTED: {
                return visitor.visitRejected();
            }
            case APPROVED: {
                return visitor.visitApproved();
            }
            case PENDING: {
                return visitor.visitPending();
            }
            case FAILED: {
                return visitor.visitFailed();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static RefundStatus valueOf(String value) {
        switch (value) {
            case "REJECTED": {
                return REJECTED;
            }
            case "APPROVED": {
                return APPROVED;
            }
            case "PENDING": {
                return PENDING;
            }
            case "FAILED": {
                return FAILED;
            }
        }
        return new RefundStatus(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitPending();

        public T visitApproved();

        public T visitRejected();

        public T visitFailed();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        PENDING,
        APPROVED,
        REJECTED,
        FAILED,
        UNKNOWN;

    }
}

