/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Range {
    private final Optional<String> min;
    private final Optional<String> max;
    private final Map<String, Object> additionalProperties;

    private Range(Optional<String> min, Optional<String> max, Map<String, Object> additionalProperties) {
        this.min = min;
        this.max = max;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getMin() {
        if (this.min == null) {
            return Optional.empty();
        }
        return this.min;
    }

    @JsonIgnore
    public Optional<String> getMax() {
        if (this.max == null) {
            return Optional.empty();
        }
        return this.max;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="min")
    private Optional<String> _getMin() {
        return this.min;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="max")
    private Optional<String> _getMax() {
        return this.max;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Range && this.equalTo((Range)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Range other) {
        return this.min.equals(other.min) && this.max.equals(other.max);
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> min = Optional.empty();
        private Optional<String> max = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Range other) {
            this.min(other.getMin());
            this.max(other.getMax());
            return this;
        }

        @JsonSetter(value="min", nulls=Nulls.SKIP)
        public Builder min(Optional<String> min) {
            this.min = min;
            return this;
        }

        public Builder min(String min) {
            this.min = Optional.ofNullable(min);
            return this;
        }

        public Builder min(Nullable<String> min) {
            this.min = min.isNull() ? null : (min.isEmpty() ? Optional.empty() : Optional.of(min.get()));
            return this;
        }

        @JsonSetter(value="max", nulls=Nulls.SKIP)
        public Builder max(Optional<String> max) {
            this.max = max;
            return this;
        }

        public Builder max(String max) {
            this.max = Optional.ofNullable(max);
            return this;
        }

        public Builder max(Nullable<String> max) {
            this.max = max.isNull() ? null : (max.isEmpty() ? Optional.empty() : Optional.of(max.get()));
            return this;
        }

        public Range build() {
            return new Range(this.min, this.max, this.additionalProperties);
        }
    }
}

