/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.Invoice;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PublishInvoiceResponse {
    private final Optional<Invoice> invoice;
    private final Optional<List<Error>> errors;
    private final Map<String, Object> additionalProperties;

    private PublishInvoiceResponse(Optional<Invoice> invoice, Optional<List<Error>> errors, Map<String, Object> additionalProperties) {
        this.invoice = invoice;
        this.errors = errors;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="invoice")
    public Optional<Invoice> getInvoice() {
        return this.invoice;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PublishInvoiceResponse && this.equalTo((PublishInvoiceResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PublishInvoiceResponse other) {
        return this.invoice.equals(other.invoice) && this.errors.equals(other.errors);
    }

    public int hashCode() {
        return Objects.hash(this.invoice, this.errors);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Invoice> invoice = Optional.empty();
        private Optional<List<Error>> errors = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(PublishInvoiceResponse other) {
            this.invoice(other.getInvoice());
            this.errors(other.getErrors());
            return this;
        }

        @JsonSetter(value="invoice", nulls=Nulls.SKIP)
        public Builder invoice(Optional<Invoice> invoice) {
            this.invoice = invoice;
            return this;
        }

        public Builder invoice(Invoice invoice) {
            this.invoice = Optional.ofNullable(invoice);
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        public PublishInvoiceResponse build() {
            return new PublishInvoiceResponse(this.invoice, this.errors, this.additionalProperties);
        }
    }
}

