/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PublishInvoiceRequest {
    private final String invoiceId;
    private final int version;
    private final Optional<String> idempotencyKey;
    private final Map<String, Object> additionalProperties;

    private PublishInvoiceRequest(String invoiceId, int version, Optional<String> idempotencyKey, Map<String, Object> additionalProperties) {
        this.invoiceId = invoiceId;
        this.version = version;
        this.idempotencyKey = idempotencyKey;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="invoice_id")
    public String getInvoiceId() {
        return this.invoiceId;
    }

    @JsonProperty(value="version")
    public int getVersion() {
        return this.version;
    }

    @JsonIgnore
    public Optional<String> getIdempotencyKey() {
        if (this.idempotencyKey == null) {
            return Optional.empty();
        }
        return this.idempotencyKey;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="idempotency_key")
    private Optional<String> _getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PublishInvoiceRequest && this.equalTo((PublishInvoiceRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PublishInvoiceRequest other) {
        return this.invoiceId.equals(other.invoiceId) && this.version == other.version && this.idempotencyKey.equals(other.idempotencyKey);
    }

    public int hashCode() {
        return Objects.hash(this.invoiceId, this.version, this.idempotencyKey);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static InvoiceIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements InvoiceIdStage,
    VersionStage,
    _FinalStage {
        private String invoiceId;
        private int version;
        private Optional<String> idempotencyKey = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(PublishInvoiceRequest other) {
            this.invoiceId(other.getInvoiceId());
            this.version(other.getVersion());
            this.idempotencyKey(other.getIdempotencyKey());
            return this;
        }

        @Override
        @JsonSetter(value="invoice_id")
        public VersionStage invoiceId(@NotNull String invoiceId) {
            this.invoiceId = Objects.requireNonNull(invoiceId, "invoiceId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="version")
        public _FinalStage version(int version) {
            this.version = version;
            return this;
        }

        @Override
        public _FinalStage idempotencyKey(Nullable<String> idempotencyKey) {
            this.idempotencyKey = idempotencyKey.isNull() ? null : (idempotencyKey.isEmpty() ? Optional.empty() : Optional.of(idempotencyKey.get()));
            return this;
        }

        @Override
        public _FinalStage idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = Optional.ofNullable(idempotencyKey);
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key", nulls=Nulls.SKIP)
        public _FinalStage idempotencyKey(Optional<String> idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        @Override
        public PublishInvoiceRequest build() {
            return new PublishInvoiceRequest(this.invoiceId, this.version, this.idempotencyKey, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public PublishInvoiceRequest build();

        public _FinalStage idempotencyKey(Optional<String> var1);

        public _FinalStage idempotencyKey(String var1);

        public _FinalStage idempotencyKey(Nullable<String> var1);
    }

    public static interface VersionStage {
        public _FinalStage version(int var1);
    }

    public static interface InvoiceIdStage {
        public VersionStage invoiceId(@NotNull String var1);

        public Builder from(PublishInvoiceRequest var1);
    }
}

