/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PhaseInput {
    private final long ordinal;
    private final Optional<String> orderTemplateId;
    private final Map<String, Object> additionalProperties;

    private PhaseInput(long ordinal, Optional<String> orderTemplateId, Map<String, Object> additionalProperties) {
        this.ordinal = ordinal;
        this.orderTemplateId = orderTemplateId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="ordinal")
    public long getOrdinal() {
        return this.ordinal;
    }

    @JsonIgnore
    public Optional<String> getOrderTemplateId() {
        if (this.orderTemplateId == null) {
            return Optional.empty();
        }
        return this.orderTemplateId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="order_template_id")
    private Optional<String> _getOrderTemplateId() {
        return this.orderTemplateId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PhaseInput && this.equalTo((PhaseInput)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PhaseInput other) {
        return this.ordinal == other.ordinal && this.orderTemplateId.equals(other.orderTemplateId);
    }

    public int hashCode() {
        return Objects.hash(this.ordinal, this.orderTemplateId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static OrdinalStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements OrdinalStage,
    _FinalStage {
        private long ordinal;
        private Optional<String> orderTemplateId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(PhaseInput other) {
            this.ordinal(other.getOrdinal());
            this.orderTemplateId(other.getOrderTemplateId());
            return this;
        }

        @Override
        @JsonSetter(value="ordinal")
        public _FinalStage ordinal(long ordinal) {
            this.ordinal = ordinal;
            return this;
        }

        @Override
        public _FinalStage orderTemplateId(Nullable<String> orderTemplateId) {
            this.orderTemplateId = orderTemplateId.isNull() ? null : (orderTemplateId.isEmpty() ? Optional.empty() : Optional.of(orderTemplateId.get()));
            return this;
        }

        @Override
        public _FinalStage orderTemplateId(String orderTemplateId) {
            this.orderTemplateId = Optional.ofNullable(orderTemplateId);
            return this;
        }

        @Override
        @JsonSetter(value="order_template_id", nulls=Nulls.SKIP)
        public _FinalStage orderTemplateId(Optional<String> orderTemplateId) {
            this.orderTemplateId = orderTemplateId;
            return this;
        }

        @Override
        public PhaseInput build() {
            return new PhaseInput(this.ordinal, this.orderTemplateId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public PhaseInput build();

        public _FinalStage orderTemplateId(Optional<String> var1);

        public _FinalStage orderTemplateId(String var1);

        public _FinalStage orderTemplateId(Nullable<String> var1);
    }

    public static interface OrdinalStage {
        public _FinalStage ordinal(long var1);

        public Builder from(PhaseInput var1);
    }
}

