/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PaymentBalanceActivityOpenDisputeDetail {
    private final Optional<String> paymentId;
    private final Optional<String> disputeId;
    private final Map<String, Object> additionalProperties;

    private PaymentBalanceActivityOpenDisputeDetail(Optional<String> paymentId, Optional<String> disputeId, Map<String, Object> additionalProperties) {
        this.paymentId = paymentId;
        this.disputeId = disputeId;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getPaymentId() {
        if (this.paymentId == null) {
            return Optional.empty();
        }
        return this.paymentId;
    }

    @JsonIgnore
    public Optional<String> getDisputeId() {
        if (this.disputeId == null) {
            return Optional.empty();
        }
        return this.disputeId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="payment_id")
    private Optional<String> _getPaymentId() {
        return this.paymentId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="dispute_id")
    private Optional<String> _getDisputeId() {
        return this.disputeId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PaymentBalanceActivityOpenDisputeDetail && this.equalTo((PaymentBalanceActivityOpenDisputeDetail)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PaymentBalanceActivityOpenDisputeDetail other) {
        return this.paymentId.equals(other.paymentId) && this.disputeId.equals(other.disputeId);
    }

    public int hashCode() {
        return Objects.hash(this.paymentId, this.disputeId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> paymentId = Optional.empty();
        private Optional<String> disputeId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(PaymentBalanceActivityOpenDisputeDetail other) {
            this.paymentId(other.getPaymentId());
            this.disputeId(other.getDisputeId());
            return this;
        }

        @JsonSetter(value="payment_id", nulls=Nulls.SKIP)
        public Builder paymentId(Optional<String> paymentId) {
            this.paymentId = paymentId;
            return this;
        }

        public Builder paymentId(String paymentId) {
            this.paymentId = Optional.ofNullable(paymentId);
            return this;
        }

        public Builder paymentId(Nullable<String> paymentId) {
            this.paymentId = paymentId.isNull() ? null : (paymentId.isEmpty() ? Optional.empty() : Optional.of(paymentId.get()));
            return this;
        }

        @JsonSetter(value="dispute_id", nulls=Nulls.SKIP)
        public Builder disputeId(Optional<String> disputeId) {
            this.disputeId = disputeId;
            return this;
        }

        public Builder disputeId(String disputeId) {
            this.disputeId = Optional.ofNullable(disputeId);
            return this;
        }

        public Builder disputeId(Nullable<String> disputeId) {
            this.disputeId = disputeId.isNull() ? null : (disputeId.isEmpty() ? Optional.empty() : Optional.of(disputeId.get()));
            return this;
        }

        public PaymentBalanceActivityOpenDisputeDetail build() {
            return new PaymentBalanceActivityOpenDisputeDetail(this.paymentId, this.disputeId, this.additionalProperties);
        }
    }
}

