/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.Order;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PayOrderResponse {
    private final Optional<List<Error>> errors;
    private final Optional<Order> order;
    private final Map<String, Object> additionalProperties;

    private PayOrderResponse(Optional<List<Error>> errors, Optional<Order> order, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.order = order;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="order")
    public Optional<Order> getOrder() {
        return this.order;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PayOrderResponse && this.equalTo((PayOrderResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PayOrderResponse other) {
        return this.errors.equals(other.errors) && this.order.equals(other.order);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.order);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<Order> order = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(PayOrderResponse other) {
            this.errors(other.getErrors());
            this.order(other.getOrder());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="order", nulls=Nulls.SKIP)
        public Builder order(Optional<Order> order) {
            this.order = order;
            return this;
        }

        public Builder order(Order order) {
            this.order = Optional.ofNullable(order);
            return this;
        }

        public PayOrderResponse build() {
            return new PayOrderResponse(this.errors, this.order, this.additionalProperties);
        }
    }
}

