/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class OrderReward {
    private final String id;
    private final String rewardTierId;
    private final Map<String, Object> additionalProperties;

    private OrderReward(String id, String rewardTierId, Map<String, Object> additionalProperties) {
        this.id = id;
        this.rewardTierId = rewardTierId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="reward_tier_id")
    public String getRewardTierId() {
        return this.rewardTierId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof OrderReward && this.equalTo((OrderReward)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OrderReward other) {
        return this.id.equals(other.id) && this.rewardTierId.equals(other.rewardTierId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.rewardTierId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    RewardTierIdStage,
    _FinalStage {
        private String id;
        private String rewardTierId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(OrderReward other) {
            this.id(other.getId());
            this.rewardTierId(other.getRewardTierId());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public RewardTierIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="reward_tier_id")
        public _FinalStage rewardTierId(@NotNull String rewardTierId) {
            this.rewardTierId = Objects.requireNonNull(rewardTierId, "rewardTierId must not be null");
            return this;
        }

        @Override
        public OrderReward build() {
            return new OrderReward(this.id, this.rewardTierId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public OrderReward build();
    }

    public static interface RewardTierIdStage {
        public _FinalStage rewardTierId(@NotNull String var1);
    }

    public static interface IdStage {
        public RewardTierIdStage id(@NotNull String var1);

        public Builder from(OrderReward var1);
    }
}

