/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class OrderPricingOptions {
    private final Optional<Boolean> autoApplyDiscounts;
    private final Optional<Boolean> autoApplyTaxes;
    private final Map<String, Object> additionalProperties;

    private OrderPricingOptions(Optional<Boolean> autoApplyDiscounts, Optional<Boolean> autoApplyTaxes, Map<String, Object> additionalProperties) {
        this.autoApplyDiscounts = autoApplyDiscounts;
        this.autoApplyTaxes = autoApplyTaxes;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<Boolean> getAutoApplyDiscounts() {
        if (this.autoApplyDiscounts == null) {
            return Optional.empty();
        }
        return this.autoApplyDiscounts;
    }

    @JsonIgnore
    public Optional<Boolean> getAutoApplyTaxes() {
        if (this.autoApplyTaxes == null) {
            return Optional.empty();
        }
        return this.autoApplyTaxes;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="auto_apply_discounts")
    private Optional<Boolean> _getAutoApplyDiscounts() {
        return this.autoApplyDiscounts;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="auto_apply_taxes")
    private Optional<Boolean> _getAutoApplyTaxes() {
        return this.autoApplyTaxes;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof OrderPricingOptions && this.equalTo((OrderPricingOptions)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OrderPricingOptions other) {
        return this.autoApplyDiscounts.equals(other.autoApplyDiscounts) && this.autoApplyTaxes.equals(other.autoApplyTaxes);
    }

    public int hashCode() {
        return Objects.hash(this.autoApplyDiscounts, this.autoApplyTaxes);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Boolean> autoApplyDiscounts = Optional.empty();
        private Optional<Boolean> autoApplyTaxes = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(OrderPricingOptions other) {
            this.autoApplyDiscounts(other.getAutoApplyDiscounts());
            this.autoApplyTaxes(other.getAutoApplyTaxes());
            return this;
        }

        @JsonSetter(value="auto_apply_discounts", nulls=Nulls.SKIP)
        public Builder autoApplyDiscounts(Optional<Boolean> autoApplyDiscounts) {
            this.autoApplyDiscounts = autoApplyDiscounts;
            return this;
        }

        public Builder autoApplyDiscounts(Boolean autoApplyDiscounts) {
            this.autoApplyDiscounts = Optional.ofNullable(autoApplyDiscounts);
            return this;
        }

        public Builder autoApplyDiscounts(Nullable<Boolean> autoApplyDiscounts) {
            this.autoApplyDiscounts = autoApplyDiscounts.isNull() ? null : (autoApplyDiscounts.isEmpty() ? Optional.empty() : Optional.of(autoApplyDiscounts.get()));
            return this;
        }

        @JsonSetter(value="auto_apply_taxes", nulls=Nulls.SKIP)
        public Builder autoApplyTaxes(Optional<Boolean> autoApplyTaxes) {
            this.autoApplyTaxes = autoApplyTaxes;
            return this;
        }

        public Builder autoApplyTaxes(Boolean autoApplyTaxes) {
            this.autoApplyTaxes = Optional.ofNullable(autoApplyTaxes);
            return this;
        }

        public Builder autoApplyTaxes(Nullable<Boolean> autoApplyTaxes) {
            this.autoApplyTaxes = autoApplyTaxes.isNull() ? null : (autoApplyTaxes.isEmpty() ? Optional.empty() : Optional.of(autoApplyTaxes.get()));
            return this;
        }

        public OrderPricingOptions build() {
            return new OrderPricingOptions(this.autoApplyDiscounts, this.autoApplyTaxes, this.additionalProperties);
        }
    }
}

