/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class OrderLineItemModifier {
    private final Optional<String> uid;
    private final Optional<String> catalogObjectId;
    private final Optional<Long> catalogVersion;
    private final Optional<String> name;
    private final Optional<String> quantity;
    private final Optional<Money> basePriceMoney;
    private final Optional<Money> totalPriceMoney;
    private final Optional<Map<String, Optional<String>>> metadata;
    private final Map<String, Object> additionalProperties;

    private OrderLineItemModifier(Optional<String> uid, Optional<String> catalogObjectId, Optional<Long> catalogVersion, Optional<String> name, Optional<String> quantity, Optional<Money> basePriceMoney, Optional<Money> totalPriceMoney, Optional<Map<String, Optional<String>>> metadata, Map<String, Object> additionalProperties) {
        this.uid = uid;
        this.catalogObjectId = catalogObjectId;
        this.catalogVersion = catalogVersion;
        this.name = name;
        this.quantity = quantity;
        this.basePriceMoney = basePriceMoney;
        this.totalPriceMoney = totalPriceMoney;
        this.metadata = metadata;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getUid() {
        if (this.uid == null) {
            return Optional.empty();
        }
        return this.uid;
    }

    @JsonIgnore
    public Optional<String> getCatalogObjectId() {
        if (this.catalogObjectId == null) {
            return Optional.empty();
        }
        return this.catalogObjectId;
    }

    @JsonIgnore
    public Optional<Long> getCatalogVersion() {
        if (this.catalogVersion == null) {
            return Optional.empty();
        }
        return this.catalogVersion;
    }

    @JsonIgnore
    public Optional<String> getName() {
        if (this.name == null) {
            return Optional.empty();
        }
        return this.name;
    }

    @JsonIgnore
    public Optional<String> getQuantity() {
        if (this.quantity == null) {
            return Optional.empty();
        }
        return this.quantity;
    }

    @JsonProperty(value="base_price_money")
    public Optional<Money> getBasePriceMoney() {
        return this.basePriceMoney;
    }

    @JsonProperty(value="total_price_money")
    public Optional<Money> getTotalPriceMoney() {
        return this.totalPriceMoney;
    }

    @JsonIgnore
    public Optional<Map<String, Optional<String>>> getMetadata() {
        if (this.metadata == null) {
            return Optional.empty();
        }
        return this.metadata;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="uid")
    private Optional<String> _getUid() {
        return this.uid;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="catalog_object_id")
    private Optional<String> _getCatalogObjectId() {
        return this.catalogObjectId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="catalog_version")
    private Optional<Long> _getCatalogVersion() {
        return this.catalogVersion;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="name")
    private Optional<String> _getName() {
        return this.name;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="quantity")
    private Optional<String> _getQuantity() {
        return this.quantity;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="metadata")
    private Optional<Map<String, Optional<String>>> _getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof OrderLineItemModifier && this.equalTo((OrderLineItemModifier)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OrderLineItemModifier other) {
        return this.uid.equals(other.uid) && this.catalogObjectId.equals(other.catalogObjectId) && this.catalogVersion.equals(other.catalogVersion) && this.name.equals(other.name) && this.quantity.equals(other.quantity) && this.basePriceMoney.equals(other.basePriceMoney) && this.totalPriceMoney.equals(other.totalPriceMoney) && this.metadata.equals(other.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.catalogObjectId, this.catalogVersion, this.name, this.quantity, this.basePriceMoney, this.totalPriceMoney, this.metadata);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> uid = Optional.empty();
        private Optional<String> catalogObjectId = Optional.empty();
        private Optional<Long> catalogVersion = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> quantity = Optional.empty();
        private Optional<Money> basePriceMoney = Optional.empty();
        private Optional<Money> totalPriceMoney = Optional.empty();
        private Optional<Map<String, Optional<String>>> metadata = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(OrderLineItemModifier other) {
            this.uid(other.getUid());
            this.catalogObjectId(other.getCatalogObjectId());
            this.catalogVersion(other.getCatalogVersion());
            this.name(other.getName());
            this.quantity(other.getQuantity());
            this.basePriceMoney(other.getBasePriceMoney());
            this.totalPriceMoney(other.getTotalPriceMoney());
            this.metadata(other.getMetadata());
            return this;
        }

        @JsonSetter(value="uid", nulls=Nulls.SKIP)
        public Builder uid(Optional<String> uid) {
            this.uid = uid;
            return this;
        }

        public Builder uid(String uid) {
            this.uid = Optional.ofNullable(uid);
            return this;
        }

        public Builder uid(Nullable<String> uid) {
            this.uid = uid.isNull() ? null : (uid.isEmpty() ? Optional.empty() : Optional.of(uid.get()));
            return this;
        }

        @JsonSetter(value="catalog_object_id", nulls=Nulls.SKIP)
        public Builder catalogObjectId(Optional<String> catalogObjectId) {
            this.catalogObjectId = catalogObjectId;
            return this;
        }

        public Builder catalogObjectId(String catalogObjectId) {
            this.catalogObjectId = Optional.ofNullable(catalogObjectId);
            return this;
        }

        public Builder catalogObjectId(Nullable<String> catalogObjectId) {
            this.catalogObjectId = catalogObjectId.isNull() ? null : (catalogObjectId.isEmpty() ? Optional.empty() : Optional.of(catalogObjectId.get()));
            return this;
        }

        @JsonSetter(value="catalog_version", nulls=Nulls.SKIP)
        public Builder catalogVersion(Optional<Long> catalogVersion) {
            this.catalogVersion = catalogVersion;
            return this;
        }

        public Builder catalogVersion(Long catalogVersion) {
            this.catalogVersion = Optional.ofNullable(catalogVersion);
            return this;
        }

        public Builder catalogVersion(Nullable<Long> catalogVersion) {
            this.catalogVersion = catalogVersion.isNull() ? null : (catalogVersion.isEmpty() ? Optional.empty() : Optional.of(catalogVersion.get()));
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder name(Nullable<String> name) {
            this.name = name.isNull() ? null : (name.isEmpty() ? Optional.empty() : Optional.of(name.get()));
            return this;
        }

        @JsonSetter(value="quantity", nulls=Nulls.SKIP)
        public Builder quantity(Optional<String> quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder quantity(String quantity) {
            this.quantity = Optional.ofNullable(quantity);
            return this;
        }

        public Builder quantity(Nullable<String> quantity) {
            this.quantity = quantity.isNull() ? null : (quantity.isEmpty() ? Optional.empty() : Optional.of(quantity.get()));
            return this;
        }

        @JsonSetter(value="base_price_money", nulls=Nulls.SKIP)
        public Builder basePriceMoney(Optional<Money> basePriceMoney) {
            this.basePriceMoney = basePriceMoney;
            return this;
        }

        public Builder basePriceMoney(Money basePriceMoney) {
            this.basePriceMoney = Optional.ofNullable(basePriceMoney);
            return this;
        }

        @JsonSetter(value="total_price_money", nulls=Nulls.SKIP)
        public Builder totalPriceMoney(Optional<Money> totalPriceMoney) {
            this.totalPriceMoney = totalPriceMoney;
            return this;
        }

        public Builder totalPriceMoney(Money totalPriceMoney) {
            this.totalPriceMoney = Optional.ofNullable(totalPriceMoney);
            return this;
        }

        @JsonSetter(value="metadata", nulls=Nulls.SKIP)
        public Builder metadata(Optional<Map<String, Optional<String>>> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder metadata(Map<String, Optional<String>> metadata) {
            this.metadata = Optional.ofNullable(metadata);
            return this;
        }

        public Builder metadata(Nullable<Map<String, Optional<String>>> metadata) {
            this.metadata = metadata.isNull() ? null : (metadata.isEmpty() ? Optional.empty() : Optional.of(metadata.get()));
            return this;
        }

        public OrderLineItemModifier build() {
            return new OrderLineItemModifier(this.uid, this.catalogObjectId, this.catalogVersion, this.name, this.quantity, this.basePriceMoney, this.totalPriceMoney, this.metadata, this.additionalProperties);
        }
    }
}

