/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class OrderLineItemItemType {
    public static final OrderLineItemItemType GIFT_CARD = new OrderLineItemItemType(Value.GIFT_CARD, "GIFT_CARD");
    public static final OrderLineItemItemType ITEM = new OrderLineItemItemType(Value.ITEM, "ITEM");
    public static final OrderLineItemItemType CUSTOM_AMOUNT = new OrderLineItemItemType(Value.CUSTOM_AMOUNT, "CUSTOM_AMOUNT");
    private final Value value;
    private final String string;

    OrderLineItemItemType(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof OrderLineItemItemType && this.string.equals(((OrderLineItemItemType)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case GIFT_CARD: {
                return visitor.visitGiftCard();
            }
            case ITEM: {
                return visitor.visitItem();
            }
            case CUSTOM_AMOUNT: {
                return visitor.visitCustomAmount();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static OrderLineItemItemType valueOf(String value) {
        switch (value) {
            case "GIFT_CARD": {
                return GIFT_CARD;
            }
            case "ITEM": {
                return ITEM;
            }
            case "CUSTOM_AMOUNT": {
                return CUSTOM_AMOUNT;
            }
        }
        return new OrderLineItemItemType(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitItem();

        public T visitCustomAmount();

        public T visitGiftCard();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        ITEM,
        CUSTOM_AMOUNT,
        GIFT_CARD,
        UNKNOWN;

    }
}

