/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class OrderFulfillmentState {
    public static final OrderFulfillmentState CANCELED = new OrderFulfillmentState(Value.CANCELED, "CANCELED");
    public static final OrderFulfillmentState PROPOSED = new OrderFulfillmentState(Value.PROPOSED, "PROPOSED");
    public static final OrderFulfillmentState COMPLETED = new OrderFulfillmentState(Value.COMPLETED, "COMPLETED");
    public static final OrderFulfillmentState RESERVED = new OrderFulfillmentState(Value.RESERVED, "RESERVED");
    public static final OrderFulfillmentState PREPARED = new OrderFulfillmentState(Value.PREPARED, "PREPARED");
    public static final OrderFulfillmentState FAILED = new OrderFulfillmentState(Value.FAILED, "FAILED");
    private final Value value;
    private final String string;

    OrderFulfillmentState(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof OrderFulfillmentState && this.string.equals(((OrderFulfillmentState)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case CANCELED: {
                return visitor.visitCanceled();
            }
            case PROPOSED: {
                return visitor.visitProposed();
            }
            case COMPLETED: {
                return visitor.visitCompleted();
            }
            case RESERVED: {
                return visitor.visitReserved();
            }
            case PREPARED: {
                return visitor.visitPrepared();
            }
            case FAILED: {
                return visitor.visitFailed();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static OrderFulfillmentState valueOf(String value) {
        switch (value) {
            case "CANCELED": {
                return CANCELED;
            }
            case "PROPOSED": {
                return PROPOSED;
            }
            case "COMPLETED": {
                return COMPLETED;
            }
            case "RESERVED": {
                return RESERVED;
            }
            case "PREPARED": {
                return PREPARED;
            }
            case "FAILED": {
                return FAILED;
            }
        }
        return new OrderFulfillmentState(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitProposed();

        public T visitReserved();

        public T visitPrepared();

        public T visitCompleted();

        public T visitCanceled();

        public T visitFailed();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        PROPOSED,
        RESERVED,
        PREPARED,
        COMPLETED,
        CANCELED,
        FAILED,
        UNKNOWN;

    }
}

