/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CheckoutMerchantSettings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class MerchantSettingsUpdatedEventObject {
    private final Optional<CheckoutMerchantSettings> merchantSettings;
    private final Map<String, Object> additionalProperties;

    private MerchantSettingsUpdatedEventObject(Optional<CheckoutMerchantSettings> merchantSettings, Map<String, Object> additionalProperties) {
        this.merchantSettings = merchantSettings;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="merchant_settings")
    public Optional<CheckoutMerchantSettings> getMerchantSettings() {
        return this.merchantSettings;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof MerchantSettingsUpdatedEventObject && this.equalTo((MerchantSettingsUpdatedEventObject)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(MerchantSettingsUpdatedEventObject other) {
        return this.merchantSettings.equals(other.merchantSettings);
    }

    public int hashCode() {
        return Objects.hash(this.merchantSettings);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<CheckoutMerchantSettings> merchantSettings = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(MerchantSettingsUpdatedEventObject other) {
            this.merchantSettings(other.getMerchantSettings());
            return this;
        }

        @JsonSetter(value="merchant_settings", nulls=Nulls.SKIP)
        public Builder merchantSettings(Optional<CheckoutMerchantSettings> merchantSettings) {
            this.merchantSettings = merchantSettings;
            return this;
        }

        public Builder merchantSettings(CheckoutMerchantSettings merchantSettings) {
            this.merchantSettings = Optional.ofNullable(merchantSettings);
            return this;
        }

        public MerchantSettingsUpdatedEventObject build() {
            return new MerchantSettingsUpdatedEventObject(this.merchantSettings, this.additionalProperties);
        }
    }
}

