/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class MeasurementUnitCustom {
    private final String name;
    private final String abbreviation;
    private final Map<String, Object> additionalProperties;

    private MeasurementUnitCustom(String name, String abbreviation, Map<String, Object> additionalProperties) {
        this.name = name;
        this.abbreviation = abbreviation;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="abbreviation")
    public String getAbbreviation() {
        return this.abbreviation;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof MeasurementUnitCustom && this.equalTo((MeasurementUnitCustom)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(MeasurementUnitCustom other) {
        return this.name.equals(other.name) && this.abbreviation.equals(other.abbreviation);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.abbreviation);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameStage,
    AbbreviationStage,
    _FinalStage {
        private String name;
        private String abbreviation;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(MeasurementUnitCustom other) {
            this.name(other.getName());
            this.abbreviation(other.getAbbreviation());
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public AbbreviationStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="abbreviation")
        public _FinalStage abbreviation(@NotNull String abbreviation) {
            this.abbreviation = Objects.requireNonNull(abbreviation, "abbreviation must not be null");
            return this;
        }

        @Override
        public MeasurementUnitCustom build() {
            return new MeasurementUnitCustom(this.name, this.abbreviation, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public MeasurementUnitCustom build();
    }

    public static interface AbbreviationStage {
        public _FinalStage abbreviation(@NotNull String var1);
    }

    public static interface NameStage {
        public AbbreviationStage name(@NotNull String var1);

        public Builder from(MeasurementUnitCustom var1);
    }
}

