/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.LoyaltyPromotionAvailableTimeData;
import com.squareup.square.types.LoyaltyPromotionIncentive;
import com.squareup.square.types.LoyaltyPromotionStatus;
import com.squareup.square.types.LoyaltyPromotionTriggerLimit;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class LoyaltyPromotion {
    private final Optional<String> id;
    private final String name;
    private final LoyaltyPromotionIncentive incentive;
    private final LoyaltyPromotionAvailableTimeData availableTime;
    private final Optional<LoyaltyPromotionTriggerLimit> triggerLimit;
    private final Optional<LoyaltyPromotionStatus> status;
    private final Optional<String> createdAt;
    private final Optional<String> canceledAt;
    private final Optional<String> updatedAt;
    private final Optional<String> loyaltyProgramId;
    private final Optional<Money> minimumSpendAmountMoney;
    private final Optional<List<String>> qualifyingItemVariationIds;
    private final Optional<List<String>> qualifyingCategoryIds;
    private final Map<String, Object> additionalProperties;

    private LoyaltyPromotion(Optional<String> id, String name, LoyaltyPromotionIncentive incentive, LoyaltyPromotionAvailableTimeData availableTime, Optional<LoyaltyPromotionTriggerLimit> triggerLimit, Optional<LoyaltyPromotionStatus> status, Optional<String> createdAt, Optional<String> canceledAt, Optional<String> updatedAt, Optional<String> loyaltyProgramId, Optional<Money> minimumSpendAmountMoney, Optional<List<String>> qualifyingItemVariationIds, Optional<List<String>> qualifyingCategoryIds, Map<String, Object> additionalProperties) {
        this.id = id;
        this.name = name;
        this.incentive = incentive;
        this.availableTime = availableTime;
        this.triggerLimit = triggerLimit;
        this.status = status;
        this.createdAt = createdAt;
        this.canceledAt = canceledAt;
        this.updatedAt = updatedAt;
        this.loyaltyProgramId = loyaltyProgramId;
        this.minimumSpendAmountMoney = minimumSpendAmountMoney;
        this.qualifyingItemVariationIds = qualifyingItemVariationIds;
        this.qualifyingCategoryIds = qualifyingCategoryIds;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="incentive")
    public LoyaltyPromotionIncentive getIncentive() {
        return this.incentive;
    }

    @JsonProperty(value="available_time")
    public LoyaltyPromotionAvailableTimeData getAvailableTime() {
        return this.availableTime;
    }

    @JsonProperty(value="trigger_limit")
    public Optional<LoyaltyPromotionTriggerLimit> getTriggerLimit() {
        return this.triggerLimit;
    }

    @JsonProperty(value="status")
    public Optional<LoyaltyPromotionStatus> getStatus() {
        return this.status;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="canceled_at")
    public Optional<String> getCanceledAt() {
        return this.canceledAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<String> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="loyalty_program_id")
    public Optional<String> getLoyaltyProgramId() {
        return this.loyaltyProgramId;
    }

    @JsonProperty(value="minimum_spend_amount_money")
    public Optional<Money> getMinimumSpendAmountMoney() {
        return this.minimumSpendAmountMoney;
    }

    @JsonIgnore
    public Optional<List<String>> getQualifyingItemVariationIds() {
        if (this.qualifyingItemVariationIds == null) {
            return Optional.empty();
        }
        return this.qualifyingItemVariationIds;
    }

    @JsonIgnore
    public Optional<List<String>> getQualifyingCategoryIds() {
        if (this.qualifyingCategoryIds == null) {
            return Optional.empty();
        }
        return this.qualifyingCategoryIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="qualifying_item_variation_ids")
    private Optional<List<String>> _getQualifyingItemVariationIds() {
        return this.qualifyingItemVariationIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="qualifying_category_ids")
    private Optional<List<String>> _getQualifyingCategoryIds() {
        return this.qualifyingCategoryIds;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LoyaltyPromotion && this.equalTo((LoyaltyPromotion)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LoyaltyPromotion other) {
        return this.id.equals(other.id) && this.name.equals(other.name) && this.incentive.equals(other.incentive) && this.availableTime.equals(other.availableTime) && this.triggerLimit.equals(other.triggerLimit) && this.status.equals(other.status) && this.createdAt.equals(other.createdAt) && this.canceledAt.equals(other.canceledAt) && this.updatedAt.equals(other.updatedAt) && this.loyaltyProgramId.equals(other.loyaltyProgramId) && this.minimumSpendAmountMoney.equals(other.minimumSpendAmountMoney) && this.qualifyingItemVariationIds.equals(other.qualifyingItemVariationIds) && this.qualifyingCategoryIds.equals(other.qualifyingCategoryIds);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.incentive, this.availableTime, this.triggerLimit, this.status, this.createdAt, this.canceledAt, this.updatedAt, this.loyaltyProgramId, this.minimumSpendAmountMoney, this.qualifyingItemVariationIds, this.qualifyingCategoryIds);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameStage,
    IncentiveStage,
    AvailableTimeStage,
    _FinalStage {
        private String name;
        private LoyaltyPromotionIncentive incentive;
        private LoyaltyPromotionAvailableTimeData availableTime;
        private Optional<List<String>> qualifyingCategoryIds = Optional.empty();
        private Optional<List<String>> qualifyingItemVariationIds = Optional.empty();
        private Optional<Money> minimumSpendAmountMoney = Optional.empty();
        private Optional<String> loyaltyProgramId = Optional.empty();
        private Optional<String> updatedAt = Optional.empty();
        private Optional<String> canceledAt = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<LoyaltyPromotionStatus> status = Optional.empty();
        private Optional<LoyaltyPromotionTriggerLimit> triggerLimit = Optional.empty();
        private Optional<String> id = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(LoyaltyPromotion other) {
            this.id(other.getId());
            this.name(other.getName());
            this.incentive(other.getIncentive());
            this.availableTime(other.getAvailableTime());
            this.triggerLimit(other.getTriggerLimit());
            this.status(other.getStatus());
            this.createdAt(other.getCreatedAt());
            this.canceledAt(other.getCanceledAt());
            this.updatedAt(other.getUpdatedAt());
            this.loyaltyProgramId(other.getLoyaltyProgramId());
            this.minimumSpendAmountMoney(other.getMinimumSpendAmountMoney());
            this.qualifyingItemVariationIds(other.getQualifyingItemVariationIds());
            this.qualifyingCategoryIds(other.getQualifyingCategoryIds());
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public IncentiveStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="incentive")
        public AvailableTimeStage incentive(@NotNull LoyaltyPromotionIncentive incentive) {
            this.incentive = Objects.requireNonNull(incentive, "incentive must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="available_time")
        public _FinalStage availableTime(@NotNull LoyaltyPromotionAvailableTimeData availableTime) {
            this.availableTime = Objects.requireNonNull(availableTime, "availableTime must not be null");
            return this;
        }

        @Override
        public _FinalStage qualifyingCategoryIds(Nullable<List<String>> qualifyingCategoryIds) {
            this.qualifyingCategoryIds = qualifyingCategoryIds.isNull() ? null : (qualifyingCategoryIds.isEmpty() ? Optional.empty() : Optional.of(qualifyingCategoryIds.get()));
            return this;
        }

        @Override
        public _FinalStage qualifyingCategoryIds(List<String> qualifyingCategoryIds) {
            this.qualifyingCategoryIds = Optional.ofNullable(qualifyingCategoryIds);
            return this;
        }

        @Override
        @JsonSetter(value="qualifying_category_ids", nulls=Nulls.SKIP)
        public _FinalStage qualifyingCategoryIds(Optional<List<String>> qualifyingCategoryIds) {
            this.qualifyingCategoryIds = qualifyingCategoryIds;
            return this;
        }

        @Override
        public _FinalStage qualifyingItemVariationIds(Nullable<List<String>> qualifyingItemVariationIds) {
            this.qualifyingItemVariationIds = qualifyingItemVariationIds.isNull() ? null : (qualifyingItemVariationIds.isEmpty() ? Optional.empty() : Optional.of(qualifyingItemVariationIds.get()));
            return this;
        }

        @Override
        public _FinalStage qualifyingItemVariationIds(List<String> qualifyingItemVariationIds) {
            this.qualifyingItemVariationIds = Optional.ofNullable(qualifyingItemVariationIds);
            return this;
        }

        @Override
        @JsonSetter(value="qualifying_item_variation_ids", nulls=Nulls.SKIP)
        public _FinalStage qualifyingItemVariationIds(Optional<List<String>> qualifyingItemVariationIds) {
            this.qualifyingItemVariationIds = qualifyingItemVariationIds;
            return this;
        }

        @Override
        public _FinalStage minimumSpendAmountMoney(Money minimumSpendAmountMoney) {
            this.minimumSpendAmountMoney = Optional.ofNullable(minimumSpendAmountMoney);
            return this;
        }

        @Override
        @JsonSetter(value="minimum_spend_amount_money", nulls=Nulls.SKIP)
        public _FinalStage minimumSpendAmountMoney(Optional<Money> minimumSpendAmountMoney) {
            this.minimumSpendAmountMoney = minimumSpendAmountMoney;
            return this;
        }

        @Override
        public _FinalStage loyaltyProgramId(String loyaltyProgramId) {
            this.loyaltyProgramId = Optional.ofNullable(loyaltyProgramId);
            return this;
        }

        @Override
        @JsonSetter(value="loyalty_program_id", nulls=Nulls.SKIP)
        public _FinalStage loyaltyProgramId(Optional<String> loyaltyProgramId) {
            this.loyaltyProgramId = loyaltyProgramId;
            return this;
        }

        @Override
        public _FinalStage updatedAt(String updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @Override
        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public _FinalStage updatedAt(Optional<String> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public _FinalStage canceledAt(String canceledAt) {
            this.canceledAt = Optional.ofNullable(canceledAt);
            return this;
        }

        @Override
        @JsonSetter(value="canceled_at", nulls=Nulls.SKIP)
        public _FinalStage canceledAt(Optional<String> canceledAt) {
            this.canceledAt = canceledAt;
            return this;
        }

        @Override
        public _FinalStage createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @Override
        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public _FinalStage createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public _FinalStage status(LoyaltyPromotionStatus status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @Override
        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public _FinalStage status(Optional<LoyaltyPromotionStatus> status) {
            this.status = status;
            return this;
        }

        @Override
        public _FinalStage triggerLimit(LoyaltyPromotionTriggerLimit triggerLimit) {
            this.triggerLimit = Optional.ofNullable(triggerLimit);
            return this;
        }

        @Override
        @JsonSetter(value="trigger_limit", nulls=Nulls.SKIP)
        public _FinalStage triggerLimit(Optional<LoyaltyPromotionTriggerLimit> triggerLimit) {
            this.triggerLimit = triggerLimit;
            return this;
        }

        @Override
        public _FinalStage id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @Override
        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public _FinalStage id(Optional<String> id) {
            this.id = id;
            return this;
        }

        @Override
        public LoyaltyPromotion build() {
            return new LoyaltyPromotion(this.id, this.name, this.incentive, this.availableTime, this.triggerLimit, this.status, this.createdAt, this.canceledAt, this.updatedAt, this.loyaltyProgramId, this.minimumSpendAmountMoney, this.qualifyingItemVariationIds, this.qualifyingCategoryIds, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public LoyaltyPromotion build();

        public _FinalStage id(Optional<String> var1);

        public _FinalStage id(String var1);

        public _FinalStage triggerLimit(Optional<LoyaltyPromotionTriggerLimit> var1);

        public _FinalStage triggerLimit(LoyaltyPromotionTriggerLimit var1);

        public _FinalStage status(Optional<LoyaltyPromotionStatus> var1);

        public _FinalStage status(LoyaltyPromotionStatus var1);

        public _FinalStage createdAt(Optional<String> var1);

        public _FinalStage createdAt(String var1);

        public _FinalStage canceledAt(Optional<String> var1);

        public _FinalStage canceledAt(String var1);

        public _FinalStage updatedAt(Optional<String> var1);

        public _FinalStage updatedAt(String var1);

        public _FinalStage loyaltyProgramId(Optional<String> var1);

        public _FinalStage loyaltyProgramId(String var1);

        public _FinalStage minimumSpendAmountMoney(Optional<Money> var1);

        public _FinalStage minimumSpendAmountMoney(Money var1);

        public _FinalStage qualifyingItemVariationIds(Optional<List<String>> var1);

        public _FinalStage qualifyingItemVariationIds(List<String> var1);

        public _FinalStage qualifyingItemVariationIds(Nullable<List<String>> var1);

        public _FinalStage qualifyingCategoryIds(Optional<List<String>> var1);

        public _FinalStage qualifyingCategoryIds(List<String> var1);

        public _FinalStage qualifyingCategoryIds(Nullable<List<String>> var1);
    }

    public static interface AvailableTimeStage {
        public _FinalStage availableTime(@NotNull LoyaltyPromotionAvailableTimeData var1);
    }

    public static interface IncentiveStage {
        public AvailableTimeStage incentive(@NotNull LoyaltyPromotionIncentive var1);
    }

    public static interface NameStage {
        public IncentiveStage name(@NotNull String var1);

        public Builder from(LoyaltyPromotion var1);
    }
}

