/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class LoyaltyEventDeleteReward {
    private final Optional<String> loyaltyProgramId;
    private final Optional<String> rewardId;
    private final Optional<Integer> points;
    private final Map<String, Object> additionalProperties;

    private LoyaltyEventDeleteReward(Optional<String> loyaltyProgramId, Optional<String> rewardId, Optional<Integer> points, Map<String, Object> additionalProperties) {
        this.loyaltyProgramId = loyaltyProgramId;
        this.rewardId = rewardId;
        this.points = points;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="loyalty_program_id")
    public Optional<String> getLoyaltyProgramId() {
        return this.loyaltyProgramId;
    }

    @JsonProperty(value="reward_id")
    public Optional<String> getRewardId() {
        return this.rewardId;
    }

    @JsonProperty(value="points")
    public Optional<Integer> getPoints() {
        return this.points;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LoyaltyEventDeleteReward && this.equalTo((LoyaltyEventDeleteReward)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LoyaltyEventDeleteReward other) {
        return this.loyaltyProgramId.equals(other.loyaltyProgramId) && this.rewardId.equals(other.rewardId) && this.points.equals(other.points);
    }

    public int hashCode() {
        return Objects.hash(this.loyaltyProgramId, this.rewardId, this.points);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> loyaltyProgramId = Optional.empty();
        private Optional<String> rewardId = Optional.empty();
        private Optional<Integer> points = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(LoyaltyEventDeleteReward other) {
            this.loyaltyProgramId(other.getLoyaltyProgramId());
            this.rewardId(other.getRewardId());
            this.points(other.getPoints());
            return this;
        }

        @JsonSetter(value="loyalty_program_id", nulls=Nulls.SKIP)
        public Builder loyaltyProgramId(Optional<String> loyaltyProgramId) {
            this.loyaltyProgramId = loyaltyProgramId;
            return this;
        }

        public Builder loyaltyProgramId(String loyaltyProgramId) {
            this.loyaltyProgramId = Optional.ofNullable(loyaltyProgramId);
            return this;
        }

        @JsonSetter(value="reward_id", nulls=Nulls.SKIP)
        public Builder rewardId(Optional<String> rewardId) {
            this.rewardId = rewardId;
            return this;
        }

        public Builder rewardId(String rewardId) {
            this.rewardId = Optional.ofNullable(rewardId);
            return this;
        }

        @JsonSetter(value="points", nulls=Nulls.SKIP)
        public Builder points(Optional<Integer> points) {
            this.points = points;
            return this;
        }

        public Builder points(Integer points) {
            this.points = Optional.ofNullable(points);
            return this;
        }

        public LoyaltyEventDeleteReward build() {
            return new LoyaltyEventDeleteReward(this.loyaltyProgramId, this.rewardId, this.points, this.additionalProperties);
        }
    }
}

